/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.embedded;

import org.springframework.core.io.ClassRelativeResourceLoader;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabase;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseFactory;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.jdbc.datasource.embedded.ResourceDatabasePopulator;

public class EmbeddedDatabaseBuilder {
    private final EmbeddedDatabaseFactory databaseFactory = new EmbeddedDatabaseFactory();
    private final ResourceDatabasePopulator databasePopulator = new ResourceDatabasePopulator();
    private final ResourceLoader resourceLoader;

    public EmbeddedDatabaseBuilder() {
        this((ResourceLoader)new DefaultResourceLoader());
    }

    public EmbeddedDatabaseBuilder(ResourceLoader resourceLoader) {
        this.databaseFactory.setDatabasePopulator(this.databasePopulator);
        this.resourceLoader = resourceLoader;
    }

    public EmbeddedDatabaseBuilder name(String databaseName) {
        this.databaseFactory.setDatabaseName(databaseName);
        return this;
    }

    public EmbeddedDatabaseBuilder type(EmbeddedDatabaseType databaseType) {
        this.databaseFactory.setDatabaseType(databaseType);
        return this;
    }

    public EmbeddedDatabaseBuilder script(String sqlResource) {
        this.databasePopulator.addScript(this.resourceLoader.getResource(sqlResource));
        return this;
    }

    public EmbeddedDatabase build() {
        return this.databaseFactory.getDatabase();
    }

    public static EmbeddedDatabase buildDefault() {
        return new EmbeddedDatabaseBuilder().script("schema.sql").script("data.sql").build();
    }

    public static EmbeddedDatabaseBuilder relativeTo(Class clazz) {
        return new EmbeddedDatabaseBuilder((ResourceLoader)new ClassRelativeResourceLoader(clazz));
    }
}

