/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.config;

import java.util.List;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.embedded.DatabasePopulator;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseFactoryBean;
import org.springframework.jdbc.datasource.embedded.ResourceDatabasePopulator;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedDatabaseBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext context) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(EmbeddedDatabaseFactoryBean.class);
        this.setDatabaseType(element, builder);
        this.setDatabasePopulator(element, context, builder);
        return this.getSourcedBeanDefinition(builder, element, context);
    }

    private void setDatabaseType(Element element, BeanDefinitionBuilder builder) {
        String type = element.getAttribute("type");
        if (StringUtils.hasText((String)type)) {
            builder.addPropertyValue("databaseType", (Object)type);
        }
    }

    private void setDatabasePopulator(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        List scripts = DomUtils.getChildElementsByTagName((Element)element, (String)"script");
        if (scripts.size() > 0) {
            builder.addPropertyValue("databasePopulator", (Object)this.createDatabasePopulator(scripts, context));
        }
    }

    private DatabasePopulator createDatabasePopulator(List<Element> scripts, ParserContext context) {
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        for (Element scriptElement : scripts) {
            Resource script = context.getReaderContext().getResourceLoader().getResource(scriptElement.getAttribute("location"));
            populator.addScript(script);
        }
        return populator;
    }

    private AbstractBeanDefinition getSourcedBeanDefinition(BeanDefinitionBuilder builder, Element source, ParserContext context) {
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        definition.setSource(context.extractSource((Object)source));
        return definition;
    }
}

