/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public class QualifiedIdentifier
extends SpelNodeImpl {
    private TypedValue value;

    public QualifiedIdentifier(int pos, SpelNodeImpl ... operands) {
        super(pos, operands);
    }

    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        if (this.value == null) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.getChildCount()) {
                Object value = this.children[i].getValueInternal(state).getValue();
                if (i > 0 && !value.toString().startsWith("$")) {
                    sb.append(".");
                }
                sb.append(value);
                ++i;
            }
            this.value = new TypedValue(sb.toString(), STRING_TYPE_DESCRIPTOR);
        }
        return this.value;
    }

    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        if (this.value != null) {
            sb.append(this.value.getValue());
        } else {
            int i = 0;
            while (i < this.getChildCount()) {
                if (i > 0) {
                    sb.append(".");
                }
                sb.append(this.getChild(i).toStringAST());
                ++i;
            }
        }
        return sb.toString();
    }
}

