/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;

public class OpOr
extends Operator {
    public OpOr(int pos, SpelNodeImpl ... operands) {
        super("or", pos, operands);
    }

    public BooleanTypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        boolean rightValue;
        boolean leftValue;
        try {
            leftValue = (Boolean)state.convertValue(this.getLeftOperand().getValueInternal(state), BOOLEAN_TYPE_DESCRIPTOR);
        }
        catch (SpelEvaluationException see) {
            see.setPosition(this.getLeftOperand().getStartPosition());
            throw see;
        }
        if (leftValue) {
            return BooleanTypedValue.True;
        }
        try {
            rightValue = (Boolean)state.convertValue(this.getRightOperand().getValueInternal(state), BOOLEAN_TYPE_DESCRIPTOR);
        }
        catch (SpelEvaluationException see) {
            see.setPosition(this.getRightOperand().getStartPosition());
            throw see;
        }
        return BooleanTypedValue.forValue(leftValue || rightValue);
    }
}

