/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Operation;
import org.springframework.expression.OperatorOverloader;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeComparator;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionState {
    private final EvaluationContext relatedContext;
    private final Stack<VariableScope> variableScopes = new Stack();
    private final Stack<TypedValue> contextObjects = new Stack();
    private int configuration = 0;

    public ExpressionState(EvaluationContext context) {
        this.relatedContext = context;
        this.createVariableScope();
    }

    public ExpressionState(EvaluationContext context, int configuration) {
        this.relatedContext = context;
        this.configuration = configuration;
        this.createVariableScope();
    }

    private void createVariableScope() {
        this.variableScopes.add(new VariableScope());
    }

    public TypedValue getActiveContextObject() {
        if (this.contextObjects.isEmpty()) {
            TypedValue rootObject = this.relatedContext.getRootObject();
            if (rootObject == null) {
                return TypedValue.NULL_TYPED_VALUE;
            }
            return rootObject;
        }
        return this.contextObjects.peek();
    }

    public void pushActiveContextObject(TypedValue obj) {
        this.contextObjects.push(obj);
    }

    public void popActiveContextObject() {
        this.contextObjects.pop();
    }

    public TypedValue getRootContextObject() {
        TypedValue root = this.relatedContext.getRootObject();
        if (root == null) {
            return TypedValue.NULL_TYPED_VALUE;
        }
        return root;
    }

    public void setVariable(String name, Object value) {
        this.relatedContext.setVariable(name, value);
    }

    public TypedValue lookupVariable(String name) {
        Object value = this.relatedContext.lookupVariable(name);
        if (value == null) {
            return TypedValue.NULL_TYPED_VALUE;
        }
        return new TypedValue(value, TypeDescriptor.forObject((Object)value));
    }

    public TypeComparator getTypeComparator() {
        return this.relatedContext.getTypeComparator();
    }

    public Class<?> findType(String type) throws EvaluationException {
        return this.relatedContext.getTypeLocator().findType(type);
    }

    public Object convertValue(Object value, TypeDescriptor targetTypeDescriptor) throws EvaluationException {
        return this.relatedContext.getTypeConverter().convertValue(value, targetTypeDescriptor);
    }

    public Object convertValue(TypedValue value, TypeDescriptor targetTypeDescriptor) throws EvaluationException {
        return this.relatedContext.getTypeConverter().convertValue(value.getValue(), targetTypeDescriptor);
    }

    public void enterScope(Map<String, Object> argMap) {
        this.variableScopes.push(new VariableScope(argMap));
    }

    public void enterScope(String name, Object value) {
        this.variableScopes.push(new VariableScope(name, value));
    }

    public void exitScope() {
        this.variableScopes.pop();
    }

    public void setLocalVariable(String name, Object value) {
        this.variableScopes.peek().setVariable(name, value);
    }

    public Object lookupLocalVariable(String name) {
        int scopeNumber;
        int i = scopeNumber = this.variableScopes.size() - 1;
        while (i >= 0) {
            if (((VariableScope)this.variableScopes.get(i)).definesVariable(name)) {
                return ((VariableScope)this.variableScopes.get(i)).lookupVariable(name);
            }
            --i;
        }
        return null;
    }

    public TypedValue operate(Operation op, Object left, Object right) throws EvaluationException {
        OperatorOverloader overloader = this.relatedContext.getOperatorOverloader();
        if (overloader.overridesOperation(op, left, right)) {
            Object returnValue = overloader.operate(op, left, right);
            return new TypedValue(returnValue, TypeDescriptor.forObject((Object)returnValue));
        }
        String leftType = left == null ? "null" : left.getClass().getName();
        String rightType = right == null ? "null" : right.getClass().getName();
        throw new SpelEvaluationException(SpelMessage.OPERATOR_NOT_SUPPORTED_BETWEEN_TYPES, new Object[]{op, leftType, rightType});
    }

    public List<PropertyAccessor> getPropertyAccessors() {
        return this.relatedContext.getPropertyAccessors();
    }

    public EvaluationContext getEvaluationContext() {
        return this.relatedContext;
    }

    public boolean configuredToGrowCollection() {
        return (this.configuration & 2) != 0;
    }

    public boolean configuredToDynamicallyCreateNullObjects() {
        return (this.configuration & 1) != 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VariableScope {
        private final Map<String, Object> vars = new HashMap<String, Object>();

        public VariableScope() {
        }

        public VariableScope(Map<String, Object> arguments) {
            if (arguments != null) {
                this.vars.putAll(arguments);
            }
        }

        public VariableScope(String name, Object value) {
            this.vars.put(name, value);
        }

        public Object lookupVariable(String name) {
            return this.vars.get(name);
        }

        public void setVariable(String name, Object value) {
            this.vars.put(name, value);
        }

        public boolean definesVariable(String name) {
            return this.vars.containsKey(name);
        }
    }
}

