/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.lang.reflect.Method;
import java.util.function.Supplier;
import org.springframework.cache.interceptor.CacheEvaluationContext;
import org.springframework.cache.interceptor.CacheExpressionRootObject;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.function.SingletonSupplier;

class CacheEvaluationContextFactory {
    private final StandardEvaluationContext originalContext;
    @Nullable
    private Supplier<ParameterNameDiscoverer> parameterNameDiscoverer;

    CacheEvaluationContextFactory(StandardEvaluationContext originalContext) {
        this.originalContext = originalContext;
    }

    public void setParameterNameDiscoverer(Supplier<ParameterNameDiscoverer> parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public ParameterNameDiscoverer getParameterNameDiscoverer() {
        if (this.parameterNameDiscoverer == null) {
            this.parameterNameDiscoverer = SingletonSupplier.of((Object)new DefaultParameterNameDiscoverer());
        }
        return this.parameterNameDiscoverer.get();
    }

    public CacheEvaluationContext forOperation(CacheExpressionRootObject rootObject, Method targetMethod, Object[] args) {
        CacheEvaluationContext evaluationContext = new CacheEvaluationContext(rootObject, targetMethod, args, this.getParameterNameDiscoverer());
        this.originalContext.applyDelegatesTo((StandardEvaluationContext)evaluationContext);
        return evaluationContext;
    }
}

