/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.annotation;

import java.util.Map;
import org.springframework.context.annotation.AdviceMode;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.context.annotation.ImportSelectorContext;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.ProxyAsyncConfiguration;
import org.springframework.util.Assert;

public class AsyncConfigurationSelector
implements ImportSelector {
    public String[] selectImports(ImportSelectorContext context) {
        AnnotationMetadata importingClassMetadata = context.getImportingClassMetadata();
        Map enableAsync = importingClassMetadata.getAnnotationAttributes(EnableAsync.class.getName());
        Assert.notNull((Object)enableAsync, (String)("@EnableAsync is not present on importing class " + importingClassMetadata.getClassName()));
        switch ((AdviceMode)((Object)enableAsync.get("mode"))) {
            case PROXY: {
                return new String[]{ProxyAsyncConfiguration.class.getName()};
            }
            case ASPECTJ: {
                return new String[]{"org.springframework.scheduling.aspectj.AspectJAsyncConfiguration"};
            }
        }
        throw new IllegalArgumentException("Unknown AdviceMode " + enableAsync.get("mode"));
    }
}

