/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CacheOperationSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeCacheOperationSource
implements CacheOperationSource,
Serializable {
    private final CacheOperationSource[] cacheOperationSources;

    public CompositeCacheOperationSource(CacheOperationSource ... cacheOperationSources) {
        Assert.notEmpty((Object[])cacheOperationSources, (String)"cacheOperationSources array must not be empty");
        this.cacheOperationSources = cacheOperationSources;
    }

    public final CacheOperationSource[] getCacheOperationSources() {
        return this.cacheOperationSources;
    }

    @Override
    public CacheOperation getCacheOperation(Method method, Class<?> targetClass) {
        CacheOperationSource[] cacheOperationSourceArray = this.cacheOperationSources;
        int n = this.cacheOperationSources.length;
        int n2 = 0;
        while (n2 < n) {
            CacheOperationSource source = cacheOperationSourceArray[n2];
            CacheOperation definition = source.getCacheOperation(method, targetClass);
            if (definition != null) {
                return definition;
            }
            ++n2;
        }
        return null;
    }
}

