/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.annotation;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import org.springframework.cache.annotation.CacheAnnotationParser;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.interceptor.CacheEvictOperation;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CacheUpdateOperation;
import org.springframework.core.annotation.AnnotationUtils;

public class SpringCacheAnnotationParser
implements CacheAnnotationParser,
Serializable {
    public CacheOperation parseCacheAnnotation(AnnotatedElement ae) {
        Cacheable update = (Cacheable)AnnotationUtils.getAnnotation((AnnotatedElement)ae, Cacheable.class);
        if (update != null) {
            return this.parseCacheableAnnotation(ae, update);
        }
        CacheEvict evict = (CacheEvict)AnnotationUtils.getAnnotation((AnnotatedElement)ae, CacheEvict.class);
        if (evict != null) {
            return this.parseEvictAnnotation(ae, evict);
        }
        return null;
    }

    CacheUpdateOperation parseCacheableAnnotation(AnnotatedElement ae, Cacheable ann) {
        CacheUpdateOperation cuo = new CacheUpdateOperation();
        cuo.setCacheNames(ann.value());
        cuo.setCondition(ann.condition());
        cuo.setKey(ann.key());
        cuo.setName(ae.toString());
        return cuo;
    }

    CacheEvictOperation parseEvictAnnotation(AnnotatedElement ae, CacheEvict ann) {
        CacheEvictOperation ceo = new CacheEvictOperation();
        ceo.setCacheNames(ann.value());
        ceo.setCondition(ann.condition());
        ceo.setKey(ann.key());
        ceo.setCacheWide(ann.allEntries());
        ceo.setName(ae.toString());
        return ceo;
    }
}

