/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.springframework.core.env.PropertySource;
import org.springframework.jndi.JndiLookupFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiPropertySource
extends PropertySource<Context> {
    public static final String JNDI_PROPERTY_SOURCE_NAME = "jndiPropertySource";
    public static final String JNDI_PROPERTY_SOURCE_ENABLED_FLAG = "jndiPropertySourceEnabled";

    public JndiPropertySource() throws JndiLookupFailureException {
        this(JNDI_PROPERTY_SOURCE_NAME, JndiPropertySource.createInitialContext(null));
    }

    public JndiPropertySource(String name) throws JndiLookupFailureException {
        this(name, JndiPropertySource.createInitialContext(null));
    }

    public JndiPropertySource(String name, Properties jndiEnvironment) throws JndiLookupFailureException {
        this(name, JndiPropertySource.createInitialContext(jndiEnvironment));
    }

    public JndiPropertySource(String name, Context source) {
        super(name, (Object)source);
    }

    public Object getProperty(String name) throws JndiLookupFailureException {
        try {
            return ((Context)this.source).lookup(name);
        }
        catch (NamingException ex) {
            throw new JndiLookupFailureException("unable to look up name" + name, ex);
        }
    }

    private static Context createInitialContext(Properties jndiEnvironment) {
        try {
            return new InitialContext(jndiEnvironment);
        }
        catch (NamingException ex) {
            throw new JndiLookupFailureException("unable to create InitialContext", ex);
        }
    }
}

