/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.context.annotation.BeanAnnotationHelper;
import org.springframework.context.annotation.EarlyBeanReferenceProxy;
import org.springframework.context.annotation.ProxyCreationException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EarlyBeanReferenceProxyCreator {
    static final String FINAL_CLASS_ERROR_MESSAGE = "Cannot create subclass proxy for bean type %s because it is a final class. Make the class non-final or inject the bean by interface rather than by concrete class.";
    static final String MISSING_NO_ARG_CONSTRUCTOR_ERROR_MESSAGE = "Cannot create subclass proxy for bean type %s because it does not have a no-arg constructor. Add a no-arg constructor or attempt to inject the bean by interface rather than by concrete class.";
    static final String PRIVATE_NO_ARG_CONSTRUCTOR_ERROR_MESSAGE = "Cannot create subclass proxy for bean type %s because its no-arg constructor is private. Increase the visibility of the no-arg constructor or attempt to inject the bean by interface rather than by concrete class.";
    private final AutowireCapableBeanFactory beanFactory;

    public EarlyBeanReferenceProxyCreator(AutowireCapableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object createProxy(DependencyDescriptor descriptor) {
        return this.doCreateProxy(new ResolveDependencyTargetBeanDereferencingInterceptor(descriptor));
    }

    private Object doCreateProxy(TargetBeanDereferencingInterceptor targetBeanDereferencingInterceptor) {
        Enhancer enhancer = new Enhancer();
        Class<?> targetBeanType = targetBeanDereferencingInterceptor.getTargetBeanType();
        if (targetBeanType.isInterface()) {
            enhancer.setSuperclass(Object.class);
            enhancer.setInterfaces(new Class[]{targetBeanType, EarlyBeanReferenceProxy.class});
        } else {
            EarlyBeanReferenceProxyCreator.assertClassIsProxyCapable(targetBeanType);
            enhancer.setSuperclass(targetBeanType);
            enhancer.setInterfaces(new Class[]{EarlyBeanReferenceProxy.class});
        }
        enhancer.setCallbacks(new Callback[]{new BeanMethodInterceptor(), new ObjectMethodsInterceptor(), targetBeanDereferencingInterceptor, new TargetBeanDelegatingMethodInterceptor()});
        enhancer.setCallbackFilter(new CallbackFilter(){

            public int accept(Method method) {
                if (BeanAnnotationHelper.isBeanAnnotated(method)) {
                    return 0;
                }
                if (ReflectionUtils.isObjectMethod((Method)method)) {
                    return 1;
                }
                if (method.getName().equals("dereferenceTargetBean")) {
                    return 2;
                }
                return 3;
            }
        });
        return enhancer.create();
    }

    private static void assertClassIsProxyCapable(Class<?> clazz) {
        Assert.isTrue((!clazz.isInterface() ? 1 : 0) != 0, (String)"class parameter must be a concrete type");
        if ((clazz.getModifiers() & 0x10) != 0) {
            throw new ProxyCreationException(String.format(FINAL_CLASS_ERROR_MESSAGE, clazz.getName()));
        }
        try {
            Constructor<?> noArgCtor = clazz.getDeclaredConstructor(new Class[0]);
            if ((noArgCtor.getModifiers() & 2) != 0) {
                throw new ProxyCreationException(String.format(PRIVATE_NO_ARG_CONSTRUCTOR_ERROR_MESSAGE, clazz.getName()));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ProxyCreationException(String.format(MISSING_NO_ARG_CONSTRUCTOR_ERROR_MESSAGE, clazz.getName()));
        }
    }

    private class BeanMethodInterceptor
    implements MethodInterceptor {
        private BeanMethodInterceptor() {
        }

        public Object intercept(Object obj, Method beanMethod, Object[] args, MethodProxy proxy) throws Throwable {
            return EarlyBeanReferenceProxyCreator.this.doCreateProxy(new ByNameLookupTargetBeanDereferencingInterceptor(beanMethod));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ByNameLookupTargetBeanDereferencingInterceptor
    implements TargetBeanDereferencingInterceptor {
        private final Method beanMethod;

        public ByNameLookupTargetBeanDereferencingInterceptor(Method beanMethod) {
            this.beanMethod = beanMethod;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            return EarlyBeanReferenceProxyCreator.this.beanFactory.getBean(BeanAnnotationHelper.determineBeanNameFor(this.beanMethod));
        }

        @Override
        public Class<?> getTargetBeanType() {
            return this.beanMethod.getReturnType();
        }
    }

    private static class ObjectMethodsInterceptor
    implements MethodInterceptor {
        private ObjectMethodsInterceptor() {
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (method.getName().equals("toString")) {
                return String.format("EarlyBeanReferenceProxy for bean of type %s", obj.getClass().getSuperclass().getSimpleName());
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(obj);
            }
            if (method.getName().equals("equals")) {
                if (obj == args[0]) {
                    return true;
                }
                return false;
            }
            if (method.getName().equals("finalize")) {
                return null;
            }
            return proxy.invokeSuper(obj, args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResolveDependencyTargetBeanDereferencingInterceptor
    implements TargetBeanDereferencingInterceptor {
        private final DependencyDescriptor descriptor;

        public ResolveDependencyTargetBeanDereferencingInterceptor(DependencyDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            return EarlyBeanReferenceProxyCreator.this.beanFactory.resolveDependency(this.descriptor, null);
        }

        @Override
        public Class<?> getTargetBeanType() {
            return this.descriptor.getDependencyType();
        }
    }

    private static class TargetBeanDelegatingMethodInterceptor
    implements MethodInterceptor {
        private TargetBeanDelegatingMethodInterceptor() {
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            Object targetBean = ((EarlyBeanReferenceProxy)obj).dereferenceTargetBean();
            return method.invoke(targetBean, args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface TargetBeanDereferencingInterceptor
    extends MethodInterceptor {
        public Class<?> getTargetBeanType();
    }
}

