/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ComponentScanSpec;
import org.springframework.context.config.AbstractSpecificationExecutor;
import org.springframework.context.config.SpecificationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.TypeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ComponentScanExecutor
extends AbstractSpecificationExecutor<ComponentScanSpec> {
    ComponentScanExecutor() {
    }

    @Override
    protected void doExecute(ComponentScanSpec spec, SpecificationContext specificationContext) {
        TypeFilter filter;
        BeanDefinitionRegistry registry = specificationContext.getRegistry();
        ResourceLoader resourceLoader = specificationContext.getResourceLoader();
        Environment environment = specificationContext.getEnvironment();
        ClassPathBeanDefinitionScanner scanner = spec.useDefaultFilters() == null ? new ClassPathBeanDefinitionScanner(registry) : new ClassPathBeanDefinitionScanner(registry, spec.useDefaultFilters());
        scanner.setResourceLoader(resourceLoader);
        scanner.setEnvironment(environment);
        if (spec.beanDefinitionDefaults() != null) {
            scanner.setBeanDefinitionDefaults(spec.beanDefinitionDefaults());
        }
        if (spec.autowireCandidatePatterns() != null) {
            scanner.setAutowireCandidatePatterns(spec.autowireCandidatePatterns());
        }
        if (spec.resourcePattern() != null) {
            scanner.setResourcePattern(spec.resourcePattern());
        }
        if (spec.beanNameGenerator() != null) {
            scanner.setBeanNameGenerator(spec.beanNameGenerator());
        }
        if (spec.includeAnnotationConfig() != null) {
            scanner.setIncludeAnnotationConfig(spec.includeAnnotationConfig());
        }
        if (spec.scopeMetadataResolver() != null) {
            scanner.setScopeMetadataResolver(spec.scopeMetadataResolver());
        }
        if (spec.scopedProxyMode() != null) {
            scanner.setScopedProxyMode(spec.scopedProxyMode());
        }
        TypeFilter[] typeFilterArray = spec.includeFilters();
        int n = typeFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            filter = typeFilterArray[n2];
            scanner.addIncludeFilter(filter);
            ++n2;
        }
        typeFilterArray = spec.excludeFilters();
        n = typeFilterArray.length;
        n2 = 0;
        while (n2 < n) {
            filter = typeFilterArray[n2];
            scanner.addExcludeFilter(filter);
            ++n2;
        }
        Set<BeanDefinitionHolder> scannedBeans = scanner.doScan(spec.basePackages());
        Object source = spec.source();
        String sourceName = spec.sourceName();
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(sourceName, source);
        for (BeanDefinitionHolder beanDefHolder : scannedBeans) {
            compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition(beanDefHolder));
        }
        if (spec.includeAnnotationConfig() != null && spec.includeAnnotationConfig().booleanValue()) {
            Set<BeanDefinitionHolder> processorDefinitions = AnnotationConfigUtils.registerAnnotationConfigProcessors(registry, source);
            for (BeanDefinitionHolder processorDefinition : processorDefinitions) {
                compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition(processorDefinition));
            }
        }
        specificationContext.getRegistrar().registerComponent((ComponentDefinition)compositeDef);
    }
}

