/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.cache.interceptor.CacheDefinitionSource;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CacheDefinitionSourcePointcut
extends StaticMethodMatcherPointcut
implements Serializable {
    CacheDefinitionSourcePointcut() {
    }

    public boolean matches(Method method, Class<?> targetClass) {
        CacheDefinitionSource cas = this.getCacheDefinitionSource();
        return cas == null || cas.getCacheDefinition(method, targetClass) != null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CacheDefinitionSourcePointcut)) {
            return false;
        }
        CacheDefinitionSourcePointcut otherPc = (CacheDefinitionSourcePointcut)other;
        return ObjectUtils.nullSafeEquals((Object)this.getCacheDefinitionSource(), (Object)otherPc.getCacheDefinitionSource());
    }

    public int hashCode() {
        return CacheDefinitionSourcePointcut.class.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": " + this.getCacheDefinitionSource();
    }

    protected abstract CacheDefinitionSource getCacheDefinitionSource();
}

