/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.KeyGenerator;
import org.springframework.cache.interceptor.CacheDefinition;
import org.springframework.cache.interceptor.CacheDefinitionSource;
import org.springframework.cache.interceptor.CacheInvalidateDefinition;
import org.springframework.cache.interceptor.CacheUpdateDefinition;
import org.springframework.cache.interceptor.CompositeCacheDefinitionSource;
import org.springframework.cache.interceptor.ExpressionEvaluator;
import org.springframework.cache.support.DefaultKeyGenerator;
import org.springframework.expression.EvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheAspectSupport
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CacheManager cacheManager;
    private CacheDefinitionSource cacheDefinitionSource;
    private final ExpressionEvaluator evaluator = new ExpressionEvaluator();
    private KeyGenerator<?> keyGenerator = new DefaultKeyGenerator();

    public void afterPropertiesSet() {
        if (this.cacheManager == null) {
            throw new IllegalStateException("Setting the property 'cacheManager' is required");
        }
        if (this.cacheDefinitionSource == null) {
            throw new IllegalStateException("Either 'cacheDefinitionSource' or 'cacheDefinitionSources' is required: If there are no cacheable methods, then don't use a cache aspect.");
        }
    }

    protected String methodIdentification(Method method, Class<?> targetClass) {
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, targetClass);
        return ClassUtils.getQualifiedMethodName((Method)specificMethod);
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheDefinitionSource getCacheDefinitionSource() {
        return this.cacheDefinitionSource;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public <K> void setKeyGenerator(KeyGenerator<K> keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void setCacheDefinitionSources(CacheDefinitionSource ... cacheDefinitionSources) {
        Assert.notEmpty((Object[])cacheDefinitionSources);
        this.cacheDefinitionSource = cacheDefinitionSources.length > 1 ? new CompositeCacheDefinitionSource(cacheDefinitionSources) : cacheDefinitionSources[0];
    }

    protected Collection<Cache<?, ?>> getCaches(CacheDefinition definition) {
        Set<String> cacheNames = definition.getCacheNames();
        ArrayList caches = new ArrayList(cacheNames.size());
        for (String cacheName : cacheNames) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) {
                throw new IllegalArgumentException("Cannot find cache named [" + cacheName + "] for " + definition);
            }
            caches.add(cache);
        }
        return caches;
    }

    protected CacheOperationContext getOperationContext(CacheDefinition definition, Method method, Object[] args, Class<?> targetClass) {
        return new CacheOperationContext(definition, method, args, targetClass);
    }

    protected Object execute(Callable<Object> invocation, Object target, Method method, Object[] args) throws Exception {
        Class<?> targetClass = AopProxyUtils.ultimateTargetClass((Object)target);
        if (targetClass == null && target != null) {
            targetClass = target.getClass();
        }
        CacheDefinition cacheDef = this.getCacheDefinitionSource().getCacheDefinition(method, targetClass);
        Object retVal = null;
        if (cacheDef != null) {
            CacheOperationContext context = this.getOperationContext(cacheDef, method, args, targetClass);
            Collection<Cache<?, ?>> caches = context.getCaches();
            if (context.hasConditionPassed()) {
                if (cacheDef instanceof CacheUpdateDefinition) {
                    Object key = context.generateKey();
                    if (key == null) {
                        throw new IllegalArgumentException("Null key returned for cache definition " + cacheDef);
                    }
                    if (caches.size() == 1) {
                        Cache<?, ?> cache = caches.iterator().next();
                        if (cache.containsKey(key)) {
                            retVal = cache.get(key);
                        } else {
                            retVal = invocation.call();
                            cache.put(key, retVal);
                        }
                    } else {
                        boolean cacheHit = false;
                        Iterator<Cache<?, ?>> iterator = caches.iterator();
                        while (iterator.hasNext() && !cacheHit) {
                            Cache<?, ?> cache = iterator.next();
                            if (!cache.containsKey(key)) continue;
                            retVal = cache.get(key);
                            cacheHit = true;
                        }
                        if (!cacheHit) {
                            retVal = invocation.call();
                        }
                        for (Cache<?, ?> cache : caches) {
                            cache.putIfAbsent(key, retVal);
                        }
                    }
                }
                if (cacheDef instanceof CacheInvalidateDefinition) {
                    CacheInvalidateDefinition invalidateDef = (CacheInvalidateDefinition)cacheDef;
                    retVal = invocation.call();
                    Object key = null;
                    for (Cache<?, ?> cache : caches) {
                        if (invalidateDef.isCacheWide()) {
                            cache.clear();
                            continue;
                        }
                        if (key == null) {
                            key = context.generateKey();
                        }
                        cache.remove(key);
                    }
                }
                return retVal;
            }
        }
        return invocation.call();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CacheOperationContext {
        private CacheDefinition definition;
        private final Collection<Cache<?, ?>> caches;
        private final Method method;
        private final Object[] args;
        private final EvaluationContext evalContext;
        private final KeyGenerator<?> keyGenerator;

        public CacheOperationContext(CacheDefinition operationDefinition, Method method, Object[] args, Class<?> targetClass) {
            this.keyGenerator = CacheAspectSupport.this.keyGenerator;
            this.definition = operationDefinition;
            this.caches = CacheAspectSupport.this.getCaches(this.definition);
            this.method = method;
            this.args = args;
            this.evalContext = CacheAspectSupport.this.evaluator.createEvaluationContext(this.caches, method, args, targetClass);
        }

        protected boolean hasConditionPassed() {
            if (StringUtils.hasText((String)this.definition.getCondition())) {
                return CacheAspectSupport.this.evaluator.condition(this.definition.getCondition(), this.method, this.evalContext);
            }
            return true;
        }

        protected Object generateKey() {
            if (StringUtils.hasText((String)this.definition.getKey())) {
                return CacheAspectSupport.this.evaluator.key(this.definition.getKey(), this.method, this.evalContext);
            }
            return this.keyGenerator.extract(this.method, this.args);
        }

        protected Collection<Cache<?, ?>> getCaches() {
            return this.caches;
        }
    }
}

