/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.concurrent;

import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.concurrent.ConcurrentCache;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentCacheFactoryBean<K, V>
implements FactoryBean<ConcurrentCache<K, V>>,
BeanNameAware,
InitializingBean {
    private String name = "";
    private ConcurrentCache<K, V> cache;
    private ConcurrentMap<K, V> store;

    public void afterPropertiesSet() {
        this.cache = this.store == null ? new ConcurrentCache(this.name) : new ConcurrentCache<K, V>(this.store, this.name);
    }

    public ConcurrentCache<K, V> getObject() throws Exception {
        return this.cache;
    }

    public Class<?> getObjectType() {
        return this.cache != null ? this.cache.getClass() : ConcurrentCache.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanName(String beanName) {
        if (!StringUtils.hasText((String)this.name)) {
            this.setName(beanName);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStore(ConcurrentMap<K, V> store) {
        this.store = store;
    }
}

