/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.beans.PropertyEditor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.ui.format.Formatter;
import org.springframework.ui.format.FormatterRegistry;
import org.springframework.ui.format.support.FormattingConversionServiceAdapter;
import org.springframework.ui.format.support.FormattingPropertyEditorAdapter;
import org.springframework.util.Assert;
import org.springframework.validation.AbstractBindingResult;

public abstract class AbstractPropertyBindingResult
extends AbstractBindingResult {
    private FormatterRegistry formatterRegistry;

    protected AbstractPropertyBindingResult(String objectName) {
        super(objectName);
    }

    public void initFormatterLookup(FormatterRegistry formatterRegistry) {
        Assert.notNull((Object)formatterRegistry, (String)"FormatterRegistry must not be null");
        this.formatterRegistry = formatterRegistry;
        this.getPropertyAccessor().setConversionService((ConversionService)new FormattingConversionServiceAdapter(formatterRegistry));
    }

    public PropertyEditorRegistry getPropertyEditorRegistry() {
        return this.getPropertyAccessor();
    }

    protected String canonicalFieldName(String field) {
        return PropertyAccessorUtils.canonicalPropertyName((String)field);
    }

    public Class getFieldType(String field) {
        return this.getPropertyAccessor().getPropertyType(this.fixedField(field));
    }

    protected Object getActualFieldValue(String field) {
        return this.getPropertyAccessor().getPropertyValue(field);
    }

    protected Object formatFieldValue(String field, Object value) {
        Formatter<Object> formatter;
        String fixedField = this.fixedField(field);
        PropertyEditor customEditor = this.getCustomEditor(fixedField);
        if (customEditor != null) {
            customEditor.setValue(value);
            String textValue = customEditor.getAsText();
            if (textValue != null) {
                return textValue;
            }
        }
        TypeDescriptor td = this.getPropertyAccessor().getPropertyTypeDescriptor(fixedField);
        Formatter<Object> formatter2 = formatter = this.formatterRegistry != null ? this.formatterRegistry.getFormatter(td) : null;
        if (formatter != null) {
            return formatter.format(value, LocaleContextHolder.getLocale());
        }
        return value;
    }

    protected PropertyEditor getCustomEditor(String fixedField) {
        Class targetType = this.getPropertyAccessor().getPropertyType(fixedField);
        PropertyEditor editor = this.getPropertyAccessor().findCustomEditor(targetType, fixedField);
        if (editor == null) {
            editor = BeanUtils.findEditorByConvention((Class)targetType);
        }
        return editor;
    }

    public PropertyEditor findEditor(String field, Class valueType) {
        PropertyEditor editor = super.findEditor(field, valueType);
        if (editor == null) {
            Formatter<Object> formatter;
            TypeDescriptor td = field != null ? this.getPropertyAccessor().getPropertyTypeDescriptor(this.fixedField(field)) : TypeDescriptor.valueOf((Class)valueType);
            Formatter<Object> formatter2 = formatter = this.formatterRegistry != null ? this.formatterRegistry.getFormatter(td) : null;
            if (formatter != null) {
                editor = new FormattingPropertyEditorAdapter(formatter);
            }
        }
        return editor;
    }

    public abstract ConfigurablePropertyAccessor getPropertyAccessor();
}

