/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.format.number;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import org.springframework.ui.format.Formatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNumberFormatter
implements Formatter<Number> {
    private boolean lenient = false;

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    @Override
    public String format(Number integer, Locale locale) {
        if (integer == null) {
            return "";
        }
        NumberFormat format = this.getNumberFormat(locale);
        return format.format(integer);
    }

    @Override
    public Number parse(String formatted, Locale locale) throws ParseException {
        if (formatted.length() == 0) {
            return null;
        }
        NumberFormat format = this.getNumberFormat(locale);
        ParsePosition position = new ParsePosition(0);
        Number number = format.parse(formatted, position);
        if (position.getErrorIndex() != -1) {
            throw new ParseException(formatted, position.getIndex());
        }
        if (!this.lenient && formatted.length() != position.getIndex()) {
            throw new ParseException(formatted, position.getIndex());
        }
        return number;
    }

    protected abstract NumberFormat getNumberFormat(Locale var1);
}

