/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.RequiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.SourceExtractor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConfigurationClass;
import org.springframework.context.annotation.ConfigurationClassMethod;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyCreator;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationClassBeanDefinitionReader {
    private static final Log logger = LogFactory.getLog(ConfigurationClassBeanDefinitionReader.class);
    private final BeanDefinitionRegistry registry;
    private final SourceExtractor sourceExtractor;

    public ConfigurationClassBeanDefinitionReader(BeanDefinitionRegistry registry, SourceExtractor sourceExtractor) {
        this.registry = registry;
        this.sourceExtractor = sourceExtractor;
    }

    public void loadBeanDefinitions(Set<ConfigurationClass> configurationModel) {
        for (ConfigurationClass configClass : configurationModel) {
            this.loadBeanDefinitionsForConfigurationClass(configClass);
        }
    }

    private void loadBeanDefinitionsForConfigurationClass(ConfigurationClass configClass) {
        this.doLoadBeanDefinitionForConfigurationClass(configClass);
        for (ConfigurationClassMethod method : configClass.getConfigurationMethods()) {
            this.loadBeanDefinitionsForModelMethod(method);
        }
    }

    private void doLoadBeanDefinitionForConfigurationClass(ConfigurationClass configClass) {
        if (configClass.getBeanName() == null) {
            GenericBeanDefinition configBeanDef = new GenericBeanDefinition();
            configBeanDef.setBeanClassName(configClass.getMetadata().getClassName());
            String configBeanName = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)configBeanDef, (BeanDefinitionRegistry)this.registry);
            configClass.setBeanName(configBeanName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Registered bean definition for imported @Configuration class %s", configBeanName));
            }
        }
    }

    private void loadBeanDefinitionsForModelMethod(ConfigurationClassMethod method) {
        String destroyMethodName;
        String initMethodName;
        Autowire autowire;
        String[] dependsOn;
        BeanDefinition existingBeanDef;
        ConfigurationClass configClass = method.getDeclaringClass();
        MethodMetadata metadata = method.getMetadata();
        ConfigurationClassBeanDefinition beanDef = new ConfigurationClassBeanDefinition(configClass);
        beanDef.setResource(configClass.getResource());
        beanDef.setSource(this.sourceExtractor.extractSource((Object)metadata, configClass.getResource()));
        beanDef.setFactoryBeanName(configClass.getBeanName());
        beanDef.setUniqueFactoryMethodName(metadata.getMethodName());
        beanDef.setAutowireMode(3);
        beanDef.setAttribute(RequiredAnnotationBeanPostProcessor.SKIP_REQUIRED_CHECK_ATTRIBUTE, Boolean.TRUE);
        Map beanAttributes = metadata.getAnnotationAttributes(Bean.class.getName());
        ArrayList names = new ArrayList(Arrays.asList((String[])beanAttributes.get("name")));
        String beanName = names.size() > 0 ? (String)names.remove(0) : method.getMetadata().getMethodName();
        for (String alias : names) {
            this.registry.registerAlias(beanName, alias);
        }
        if (this.registry.containsBeanDefinition(beanName) && !((existingBeanDef = this.registry.getBeanDefinition(beanName)) instanceof ConfigurationClassBeanDefinition)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Skipping loading bean definition for %s: a definition for bean '%s' already exists. This is likely due to an override in XML.", method, beanName));
            }
            return;
        }
        if (metadata.isAnnotated(Primary.class.getName())) {
            beanDef.setPrimary(true);
        }
        if (metadata.isAnnotated(Lazy.class.getName())) {
            beanDef.setLazyInit((Boolean)metadata.getAnnotationAttributes(Lazy.class.getName()).get("value"));
        } else if (configClass.getMetadata().isAnnotated(Lazy.class.getName())) {
            beanDef.setLazyInit((Boolean)configClass.getMetadata().getAnnotationAttributes(Lazy.class.getName()).get("value"));
        }
        if (metadata.isAnnotated(DependsOn.class.getName()) && (dependsOn = (String[])metadata.getAnnotationAttributes(DependsOn.class.getName()).get("value")).length > 0) {
            beanDef.setDependsOn(dependsOn);
        }
        if ((autowire = (Autowire)beanAttributes.get("autowire")).isAutowire()) {
            beanDef.setAutowireMode(autowire.value());
        }
        if (StringUtils.hasText((String)(initMethodName = (String)beanAttributes.get("initMethod")))) {
            beanDef.setInitMethodName(initMethodName);
        }
        if (StringUtils.hasText((String)(destroyMethodName = (String)beanAttributes.get("destroyMethod")))) {
            beanDef.setDestroyMethodName(destroyMethodName);
        }
        ScopedProxyMode proxyMode = ScopedProxyMode.NO;
        Map scopeAttributes = metadata.getAnnotationAttributes(Scope.class.getName());
        if (scopeAttributes != null) {
            beanDef.setScope((String)scopeAttributes.get("value"));
            proxyMode = (ScopedProxyMode)((Object)scopeAttributes.get("proxyMode"));
            if (proxyMode == ScopedProxyMode.DEFAULT) {
                proxyMode = ScopedProxyMode.NO;
            }
        }
        ConfigurationClassBeanDefinition beanDefToRegister = beanDef;
        if (proxyMode != ScopedProxyMode.NO) {
            BeanDefinitionHolder proxyDef = ScopedProxyCreator.createScopedProxy(new BeanDefinitionHolder((BeanDefinition)beanDef, beanName), this.registry, proxyMode == ScopedProxyMode.TARGET_CLASS);
            beanDefToRegister = proxyDef.getBeanDefinition();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Registering bean definition for @Bean method %s.%s()", configClass.getMetadata().getClassName(), beanName));
        }
        this.registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefToRegister);
    }

    private class ConfigurationClassBeanDefinition
    extends RootBeanDefinition
    implements AnnotatedBeanDefinition {
        private AnnotationMetadata annotationMetadata;

        public ConfigurationClassBeanDefinition(ConfigurationClass configClass) {
            this.annotationMetadata = configClass.getMetadata();
        }

        private ConfigurationClassBeanDefinition(ConfigurationClassBeanDefinition original) {
            super((RootBeanDefinition)original);
            this.annotationMetadata = original.annotationMetadata;
        }

        public AnnotationMetadata getMetadata() {
            return this.annotationMetadata;
        }

        public boolean isFactoryMethod(Method candidate) {
            return super.isFactoryMethod(candidate) && AnnotationUtils.findAnnotation((Method)candidate, Bean.class) != null;
        }

        public ConfigurationClassBeanDefinition cloneBeanDefinition() {
            return new ConfigurationClassBeanDefinition(this);
        }
    }
}

