/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.method;

import java.lang.reflect.InvocationTargetException;
import org.springframework.binding.method.MethodSignature;
import org.springframework.core.NestedRuntimeException;
import org.springframework.core.style.StylerUtils;

public class MethodInvocationException
extends NestedRuntimeException {
    private transient MethodSignature methodSignature;
    private transient Object[] arguments;

    public MethodInvocationException(MethodSignature methodSignature, Object[] arguments, Throwable cause) {
        super("Unable to invoke method " + methodSignature + " with arguments " + StylerUtils.style((Object)arguments), cause);
        this.methodSignature = methodSignature;
        this.arguments = arguments;
    }

    public MethodSignature getMethodSignature() {
        return this.methodSignature;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public Throwable getTargetException() {
        Throwable targetException = this.getCause();
        while (targetException instanceof InvocationTargetException) {
            targetException = ((InvocationTargetException)targetException).getTargetException();
        }
        return targetException;
    }
}

