/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.annotation.OrderProvider;

class FactoryAwareOrderProvider
implements OrderProvider {
    private final Map<Object, String> instancesToBeanNames;
    private final ConfigurableListableBeanFactory beanFactory;

    public FactoryAwareOrderProvider(Map<Object, String> instancesToBeanNames, ConfigurableListableBeanFactory beanFactory) {
        this.instancesToBeanNames = instancesToBeanNames;
        this.beanFactory = beanFactory;
    }

    public Integer getOrder(Object obj) {
        Order order;
        Method factoryMethod = this.getFactoryMethod(this.instancesToBeanNames.get(obj));
        if (factoryMethod != null && (order = (Order)AnnotationUtils.getAnnotation((Method)factoryMethod, Order.class)) != null) {
            return order.value();
        }
        return null;
    }

    private Method getFactoryMethod(String beanName) {
        BeanDefinition bd;
        if (beanName != null && this.beanFactory.containsBeanDefinition(beanName) && (bd = this.beanFactory.getMergedBeanDefinition(beanName)) instanceof RootBeanDefinition) {
            return ((RootBeanDefinition)bd).getResolvedFactoryMethod();
        }
        return null;
    }
}

