/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.beans.PropertyEditor;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomEditorConfigurer
implements BeanFactoryPostProcessor,
BeanClassLoaderAware,
Ordered {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int order = Integer.MAX_VALUE;
    private PropertyEditorRegistrar[] propertyEditorRegistrars;
    private Map<String, String> customEditors;
    private boolean ignoreUnresolvableEditors = false;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setPropertyEditorRegistrars(PropertyEditorRegistrar[] propertyEditorRegistrars) {
        this.propertyEditorRegistrars = propertyEditorRegistrars;
    }

    public void setCustomEditors(Map<String, String> customEditors) {
        this.customEditors = customEditors;
    }

    public void setIgnoreUnresolvableEditors(boolean ignoreUnresolvableEditors) {
        this.ignoreUnresolvableEditors = ignoreUnresolvableEditors;
    }

    @Override
    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.propertyEditorRegistrars != null) {
            PropertyEditorRegistrar[] propertyEditorRegistrarArray = this.propertyEditorRegistrars;
            int n = this.propertyEditorRegistrars.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyEditorRegistrar propertyEditorRegistrar = propertyEditorRegistrarArray[n2];
                beanFactory.addPropertyEditorRegistrar(propertyEditorRegistrar);
                ++n2;
            }
        }
        if (this.customEditors != null) {
            for (Map.Entry<String, String> entry : this.customEditors.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                Class requiredType = null;
                try {
                    requiredType = ClassUtils.forName((String)key, (ClassLoader)this.beanClassLoader);
                    Class editorClass = ClassUtils.forName((String)value, (ClassLoader)this.beanClassLoader);
                    Assert.isAssignable(PropertyEditor.class, (Class)editorClass);
                    beanFactory.registerCustomEditor(requiredType, editorClass);
                }
                catch (ClassNotFoundException ex) {
                    if (this.ignoreUnresolvableEditors) {
                        this.logger.info((Object)("Skipping editor [" + value + "] for required type [" + key + "]: " + (requiredType != null ? "editor" : "required type") + " class not found."));
                        continue;
                    }
                    throw new FatalBeanException(String.valueOf(requiredType != null ? "Editor" : "Required type") + " class not found", ex);
                }
            }
        }
    }
}

