/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.config.annotation.web.http;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionListener;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.ExpiringSession;
import org.springframework.session.SessionRepository;
import org.springframework.session.security.web.authentication.SpringSessionRememberMeServices;
import org.springframework.session.web.http.CookieHttpSessionStrategy;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.session.web.http.HttpSessionStrategy;
import org.springframework.session.web.http.MultiHttpSessionStrategy;
import org.springframework.session.web.http.SessionEventHttpSessionListenerAdapter;
import org.springframework.session.web.http.SessionRepositoryFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configuration
public class SpringHttpSessionConfiguration
implements ApplicationContextAware {
    private CookieHttpSessionStrategy defaultHttpSessionStrategy = new CookieHttpSessionStrategy();
    private boolean usesSpringSessionRememberMeServices;
    private ServletContext servletContext;
    private CookieSerializer cookieSerializer;
    private HttpSessionStrategy httpSessionStrategy = this.defaultHttpSessionStrategy;
    private List<HttpSessionListener> httpSessionListeners = new ArrayList<HttpSessionListener>();

    @PostConstruct
    public void init() {
        if (this.cookieSerializer != null) {
            this.defaultHttpSessionStrategy.setCookieSerializer(this.cookieSerializer);
        } else if (this.usesSpringSessionRememberMeServices) {
            DefaultCookieSerializer cookieSerializer = new DefaultCookieSerializer();
            cookieSerializer.setRememberMeRequestAttribute(SpringSessionRememberMeServices.REMEMBER_ME_LOGIN_ATTR);
            this.defaultHttpSessionStrategy.setCookieSerializer(cookieSerializer);
        }
    }

    @Bean
    public SessionEventHttpSessionListenerAdapter sessionEventHttpSessionListenerAdapter() {
        return new SessionEventHttpSessionListenerAdapter(this.httpSessionListeners);
    }

    @Bean
    public <S extends ExpiringSession> SessionRepositoryFilter<? extends ExpiringSession> springSessionRepositoryFilter(SessionRepository<S> sessionRepository) {
        SessionRepositoryFilter<S> sessionRepositoryFilter = new SessionRepositoryFilter<S>(sessionRepository);
        sessionRepositoryFilter.setServletContext(this.servletContext);
        if (this.httpSessionStrategy instanceof MultiHttpSessionStrategy) {
            sessionRepositoryFilter.setHttpSessionStrategy((MultiHttpSessionStrategy)this.httpSessionStrategy);
        } else {
            sessionRepositoryFilter.setHttpSessionStrategy(this.httpSessionStrategy);
        }
        return sessionRepositoryFilter;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (ClassUtils.isPresent((String)"org.springframework.security.web.authentication.RememberMeServices", null)) {
            this.usesSpringSessionRememberMeServices = !ObjectUtils.isEmpty((Object[])applicationContext.getBeanNamesForType(SpringSessionRememberMeServices.class));
        }
    }

    @Autowired(required=false)
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Autowired(required=false)
    public void setCookieSerializer(CookieSerializer cookieSerializer) {
        this.cookieSerializer = cookieSerializer;
    }

    @Autowired(required=false)
    public void setHttpSessionStrategy(HttpSessionStrategy httpSessionStrategy) {
        this.httpSessionStrategy = httpSessionStrategy;
    }

    @Autowired(required=false)
    public void setHttpSessionListeners(List<HttpSessionListener> listeners) {
        this.httpSessionListeners = listeners;
    }
}

