/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.config.annotation.web.http;

import java.util.Objects;
import java.util.Optional;
import org.apache.shiro.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractGemFireHttpSessionConfiguration
extends SpringHttpSessionConfiguration
implements BeanClassLoaderAware,
EnvironmentAware {
    protected static final String SPRING_SESSION_PROPERTY_PREFIX = "spring.session.data.gemfire.";
    private ApplicationContext applicationContext;
    private ClassLoader beanClassLoader;
    private Environment environment;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        this.applicationContext = applicationContext;
    }

    protected ApplicationContext getApplicationContext() {
        Assert.state((this.applicationContext != null ? 1 : 0) != 0, (String)"The ApplicationContext was not properly configured");
        return this.applicationContext;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    protected ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    protected ConfigurableBeanFactory getBeanFactory() {
        ApplicationContext applicationContext = this.getApplicationContext();
        return (ConfigurableBeanFactory)Optional.ofNullable(applicationContext).filter(ConfigurableApplicationContext.class::isInstance).map(ConfigurableApplicationContext.class::cast).map(ConfigurableApplicationContext::getBeanFactory).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException((String)"Unable to resolve a reference to a [%1$s] from a [%2$s]", (Object[])new Object[]{ConfigurableBeanFactory.class.getName(), ObjectUtils.nullSafeClassName((Object)applicationContext)}));
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    private String propertyName(String propertyNameSuffix) {
        return String.format("%1$s%2$s", SPRING_SESSION_PROPERTY_PREFIX, propertyNameSuffix);
    }

    private String cachePropertyName(String propertyNameSuffix) {
        return this.propertyName(String.format("cache.%s", propertyNameSuffix));
    }

    private String sessionPropertyName(String propertyNameSuffix) {
        return this.propertyName(String.format("session.%s", propertyNameSuffix));
    }

    protected String clientRegionShortcutPropertyName() {
        return this.cachePropertyName("client.region.shortcut");
    }

    protected String exposeConfigurationAsPropertiesPropertyName() {
        return this.sessionPropertyName("configuration.expose");
    }

    protected String indexableSessionAttributesPropertyName() {
        return this.sessionPropertyName("attributes.indexable");
    }

    protected String indexedSessionAttributesPropertyName() {
        return this.sessionPropertyName("attributes.indexed");
    }

    protected String maxInactiveIntervalInSecondsPropertyName() {
        return this.sessionPropertyName("expiration.max-inactive-interval-seconds");
    }

    protected String poolNamePropertyName() {
        return this.cachePropertyName("client.pool.name");
    }

    protected String serverRegionShortcutPropertyName() {
        return this.cachePropertyName("server.region.shortcut");
    }

    protected String sessionExpirationPolicyBeanNamePropertyName() {
        return this.sessionPropertyName("expiration.bean-name");
    }

    protected String sessionRegionNamePropertyName() {
        return this.sessionPropertyName("region.name");
    }

    protected String sessionSerializerBeanNamePropertyName() {
        return this.sessionPropertyName("serializer.bean-name");
    }

    protected <T> T requireProperty(String propertyName, Class<T> type) {
        return (T)Optional.of(propertyName).map(it -> this.resolveProperty(propertyName, type, null)).filter(Objects::nonNull).filter(value -> !(value instanceof String) || StringUtils.hasText((String)((String)value))).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException((String)"Property [%s] is required", (Object[])new Object[]{propertyName}));
    }

    protected <T extends Enum<T>> T resolveEnumeratedProperty(String propertyName, Class<T> targetType, T defaultValue) {
        return (T)((Enum)this.resolveProperty(propertyName, targetType, defaultValue));
    }

    protected Boolean resolveProperty(String propertyName, Boolean defaultValue) {
        return this.resolveProperty(propertyName, Boolean.class, defaultValue);
    }

    protected Integer resolveProperty(String propertyName, Integer defaultValue) {
        return this.resolveProperty(propertyName, Integer.class, defaultValue);
    }

    protected String resolveProperty(String propertyName, String defaultValue) {
        return this.resolveProperty(propertyName, String.class, defaultValue);
    }

    protected String[] resolveProperty(String propertyName, String[] defaultValue) {
        return this.resolveProperty(propertyName, String[].class, defaultValue);
    }

    protected <T> T resolveProperty(String propertyName, Class<T> targetType) {
        return this.resolveProperty(propertyName, targetType, null);
    }

    protected <T> T resolveProperty(String propertyName, Class<T> targetType, T defaultValue) {
        return (T)Optional.ofNullable(this.getEnvironment()).filter(environment -> environment.containsProperty(propertyName)).map(environment -> {
            String resolvedPropertyName = environment.resolveRequiredPlaceholders(propertyName);
            return environment.getProperty(resolvedPropertyName, targetType, defaultValue);
        }).orElse(defaultValue);
    }
}

