/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.config.annotation.web.http;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.pdx.PdxSerializer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.GemfireOperations;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.IndexFactoryBean;
import org.springframework.data.gemfire.IndexType;
import org.springframework.data.gemfire.RegionAttributesFactoryBean;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.RegionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.session.Session;
import org.springframework.session.data.gemfire.AbstractGemFireOperationsSessionRepository;
import org.springframework.session.data.gemfire.GemFireOperationsSessionRepository;
import org.springframework.session.data.gemfire.config.annotation.web.http.AbstractGemFireHttpSessionConfiguration;
import org.springframework.session.data.gemfire.config.annotation.web.http.EnableGemFireHttpSession;
import org.springframework.session.data.gemfire.config.annotation.web.http.support.SessionAttributesIndexFactoryBean;
import org.springframework.session.data.gemfire.config.annotation.web.http.support.SessionCacheTypeAwareRegionFactoryBean;
import org.springframework.session.data.gemfire.config.annotation.web.http.support.SpringSessionGemFireConfigurer;
import org.springframework.session.data.gemfire.expiration.SessionExpirationPolicy;
import org.springframework.session.data.gemfire.expiration.config.SessionExpirationTimeoutAwareBeanPostProcessor;
import org.springframework.session.data.gemfire.expiration.support.SessionExpirationPolicyCustomExpiryAdapter;
import org.springframework.session.data.gemfire.serialization.SessionSerializer;
import org.springframework.session.data.gemfire.serialization.data.provider.DataSerializableSessionSerializer;
import org.springframework.session.data.gemfire.serialization.data.support.DataSerializerSessionSerializerAdapter;
import org.springframework.session.data.gemfire.serialization.pdx.provider.PdxSerializableSessionSerializer;
import org.springframework.session.data.gemfire.serialization.pdx.support.ComposablePdxSerializer;
import org.springframework.session.data.gemfire.serialization.pdx.support.PdxSerializerSessionSerializerAdapter;
import org.springframework.session.data.gemfire.support.DeltaAwareDirtyPredicate;
import org.springframework.session.data.gemfire.support.GemFireUtils;
import org.springframework.session.data.gemfire.support.IsDirtyPredicate;
import org.springframework.util.StringUtils;

@Configuration
public class GemFireHttpSessionConfiguration
extends AbstractGemFireHttpSessionConfiguration
implements ImportAware {
    public static final boolean DEFAULT_EXPOSE_CONFIGURATION_AS_PROPERTIES = false;
    public static final boolean DEFAULT_USE_DATA_SERIALIZATION = false;
    public static final int DEFAULT_MAX_INACTIVE_INTERVAL_IN_SECONDS = (int)TimeUnit.MINUTES.toSeconds(30L);
    protected static final Class<Object> SESSION_REGION_KEY_CONSTRAINT = Object.class;
    protected static final Class<AbstractGemFireOperationsSessionRepository.GemFireSession> SESSION_REGION_VALUE_CONSTRAINT = AbstractGemFireOperationsSessionRepository.GemFireSession.class;
    public static final ClientRegionShortcut DEFAULT_CLIENT_REGION_SHORTCUT = ClientRegionShortcut.PROXY;
    public static final IsDirtyPredicate DEFAULT_IS_DIRTY_PREDICATE = DeltaAwareDirtyPredicate.INSTANCE;
    public static final RegionShortcut DEFAULT_SERVER_REGION_SHORTCUT = RegionShortcut.PARTITION;
    public static final String CONFIGURER_GET_CLIENT_REGION_SHORTCUT_METHOD_NAME = GemFireHttpSessionConfiguration.findByMethodName(SpringSessionGemFireConfigurer.class, "getClientRegionShortcut");
    public static final String CONFIGURER_GET_EXPOSE_CONFIGURATION_IN_PROPERTIES_METHOD_NAME = GemFireHttpSessionConfiguration.findByMethodName(SpringSessionGemFireConfigurer.class, "getExposeConfigurationAsProperties");
    public static final String CONFIGURER_GET_INDEXABLE_SESSION_ATTRIBUTES_METHOD_NAME = GemFireHttpSessionConfiguration.findByMethodName(SpringSessionGemFireConfigurer.class, "getIndexableSessionAttributes");
    public static final String CONFIGURER_GET_MAX_INACTIVE_INTERVAL_IN_SECONDS_METHOD_NAME = GemFireHttpSessionConfiguration.findByMethodName(SpringSessionGemFireConfigurer.class, "getMaxInactiveIntervalInSeconds");
    public static final String CONFIGURER_GET_POOL_NAME_METHOD_NAME = GemFireHttpSessionConfiguration.findByMethodName(SpringSessionGemFireConfigurer.class, "getPoolName");
    public static final String CONFIGURER_GET_REGION_NAME_METHOD_NAME = GemFireHttpSessionConfiguration.findByMethodName(SpringSessionGemFireConfigurer.class, "getRegionName");
    public static final String CONFIGURER_GET_SERVER_REGION_SHORTCUT_METHOD_NAME = GemFireHttpSessionConfiguration.findByMethodName(SpringSessionGemFireConfigurer.class, "getServerRegionShortcut");
    public static final String CONFIGURER_GET_SESSION_EXPIRATION_POLICY_BEAN_NAME_METHOD_NAME = GemFireHttpSessionConfiguration.findByMethodName(SpringSessionGemFireConfigurer.class, "getSessionExpirationPolicyBeanName");
    public static final String CONFIGURER_GET_SESSION_SERIALIZER_BEAN_NAME_METHOD_NAME = GemFireHttpSessionConfiguration.findByMethodName(SpringSessionGemFireConfigurer.class, "getSessionSerializerBeanName");
    public static final String DEFAULT_POOL_NAME = "gemfirePool";
    public static final String DEFAULT_SESSION_EXPIRATION_POLICY_BEAN_NAME = "";
    public static final String DEFAULT_SESSION_REGION_NAME = "ClusteredSpringSessions";
    public static final String SESSION_DATA_SERIALIZER_BEAN_NAME = "SessionDataSerializer";
    public static final String SESSION_PDX_SERIALIZER_BEAN_NAME = "SessionPdxSerializer";
    public static final String SESSION_SERIALIZER_BEAN_ALIAS = "SessionSerializerRegisteredBeanAlias";
    public static final String DEFAULT_SESSION_SERIALIZER_BEAN_NAME = "SessionPdxSerializer";
    protected static final String SPRING_SESSION_GEMFIRE_PROPERTY_SOURCE = GemFireHttpSessionConfiguration.class.getName().concat(".PROPERTY_SOURCE");
    public static final String[] DEFAULT_INDEXABLE_SESSION_ATTRIBUTES = new String[0];
    private boolean exposeConfigurationAsProperties = false;
    private boolean usingDataSerialization = false;
    private int maxInactiveIntervalInSeconds = DEFAULT_MAX_INACTIVE_INTERVAL_IN_SECONDS;
    private ClientRegionShortcut clientRegionShortcut = DEFAULT_CLIENT_REGION_SHORTCUT;
    private IsDirtyPredicate dirtyPredicate = DEFAULT_IS_DIRTY_PREDICATE;
    private RegionShortcut serverRegionShortcut = DEFAULT_SERVER_REGION_SHORTCUT;
    private String poolName = "gemfirePool";
    private String sessionExpirationPolicyBeanName = "";
    private String sessionRegionName = "ClusteredSpringSessions";
    private String sessionSerializerBeanName = "SessionPdxSerializer";
    private String[] indexableSessionAttributes = DEFAULT_INDEXABLE_SESSION_ATTRIBUTES;

    @NonNull
    private static String findByMethodName(@NonNull Class<?> type, @NonNull String methodName) {
        return Arrays.stream(type.getDeclaredMethods()).map(Method::getName).filter(declaredMethodName -> declaredMethodName.startsWith(methodName)).findFirst().orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException((String)"No method with name [%1$s] was found on class [%2$s]", (Object[])new Object[]{methodName, type.getName()}));
    }

    private static Optional<String> safeFindByMethodName(@NonNull Class<?> type, @NonNull String methodName) {
        try {
            return Optional.of(GemFireHttpSessionConfiguration.findByMethodName(type, methodName));
        }
        catch (Throwable ignore) {
            return Optional.empty();
        }
    }

    private static boolean isOverriddenMethodPresent(@Nullable Object target, @Nullable String methodName) {
        return Optional.ofNullable(target).map(Object::getClass).flatMap(targetType -> GemFireHttpSessionConfiguration.safeFindByMethodName(targetType, methodName)).isPresent();
    }

    public void setClientRegionShortcut(ClientRegionShortcut shortcut) {
        this.clientRegionShortcut = shortcut;
    }

    public ClientRegionShortcut getClientRegionShortcut() {
        return this.clientRegionShortcut != null ? this.clientRegionShortcut : DEFAULT_CLIENT_REGION_SHORTCUT;
    }

    public void setExposeConfigurationAsProperties(boolean exposeConfigurationAsProperties) {
        this.exposeConfigurationAsProperties = exposeConfigurationAsProperties;
    }

    public boolean isExposeConfigurationAsProperties() {
        return this.exposeConfigurationAsProperties;
    }

    public void setIndexableSessionAttributes(String[] indexableSessionAttributes) {
        this.indexableSessionAttributes = indexableSessionAttributes;
    }

    public String[] getIndexableSessionAttributes() {
        return this.indexableSessionAttributes != null ? this.indexableSessionAttributes : DEFAULT_INDEXABLE_SESSION_ATTRIBUTES;
    }

    @Autowired(required=false)
    public void setIsDirtyPredicate(IsDirtyPredicate dirtyPredicate) {
        this.dirtyPredicate = dirtyPredicate;
    }

    public IsDirtyPredicate getIsDirtyPredicate() {
        return this.dirtyPredicate != null ? this.dirtyPredicate : DEFAULT_IS_DIRTY_PREDICATE;
    }

    public void setMaxInactiveIntervalInSeconds(int maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    public int getMaxInactiveIntervalInSeconds() {
        return this.maxInactiveIntervalInSeconds;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public String getPoolName() {
        return StringUtils.hasText((String)this.poolName) ? this.poolName : DEFAULT_POOL_NAME;
    }

    public void setServerRegionShortcut(RegionShortcut shortcut) {
        this.serverRegionShortcut = shortcut;
    }

    public RegionShortcut getServerRegionShortcut() {
        return this.serverRegionShortcut != null ? this.serverRegionShortcut : DEFAULT_SERVER_REGION_SHORTCUT;
    }

    public void setSessionExpirationPolicyBeanName(String sessionExpirationPolicyBeanName) {
        this.sessionExpirationPolicyBeanName = sessionExpirationPolicyBeanName;
    }

    public Optional<String> getSessionExpirationPolicyBeanName() {
        return Optional.ofNullable(this.sessionExpirationPolicyBeanName).filter(StringUtils::hasText);
    }

    public void setSessionRegionName(String sessionRegionName) {
        this.sessionRegionName = sessionRegionName;
    }

    public String getSessionRegionName() {
        return StringUtils.hasText((String)this.sessionRegionName) ? this.sessionRegionName : DEFAULT_SESSION_REGION_NAME;
    }

    public void setSessionSerializerBeanName(String sessionSerializerBeanName) {
        this.sessionSerializerBeanName = sessionSerializerBeanName;
    }

    public String getSessionSerializerBeanName() {
        return StringUtils.hasText((String)this.sessionSerializerBeanName) ? this.sessionSerializerBeanName : "SessionPdxSerializer";
    }

    private void setUseDataSerialization(boolean useDataSerialization) {
        this.usingDataSerialization = useDataSerialization;
    }

    protected boolean isUsingDataSerialization() {
        return this.usingDataSerialization || SESSION_DATA_SERIALIZER_BEAN_NAME.equals(this.getSessionSerializerBeanName());
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        AnnotationAttributes enableGemFireHttpSessionAttributes = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableGemFireHttpSession.class.getName()));
        this.configureClientRegionShortcut(enableGemFireHttpSessionAttributes);
        this.configureExposeConfigurationAsProperties(enableGemFireHttpSessionAttributes);
        this.configureIndexedSessionAttributes(enableGemFireHttpSessionAttributes);
        this.configureMaxInactiveIntervalInSeconds(enableGemFireHttpSessionAttributes);
        this.configurePoolName(enableGemFireHttpSessionAttributes);
        this.configureServerRegionShortcut(enableGemFireHttpSessionAttributes);
        this.configureSessionExpirationPolicyBeanName(enableGemFireHttpSessionAttributes);
        this.configureSessionRegionName(enableGemFireHttpSessionAttributes);
        this.configureSessionSerializerBeanName(enableGemFireHttpSessionAttributes);
        this.applySpringSessionGemFireConfigurer();
        this.exposeSpringSessionGemFireConfiguration();
    }

    private void configureClientRegionShortcut(AnnotationAttributes enableGemFireHttpSessionAttributes) {
        ClientRegionShortcut defaultClientRegionShortcut = (ClientRegionShortcut)enableGemFireHttpSessionAttributes.getEnum("clientRegionShortcut");
        this.setClientRegionShortcut(this.resolveProperty(this.clientRegionShortcutPropertyName(), ClientRegionShortcut.class, defaultClientRegionShortcut));
    }

    private void configureExposeConfigurationAsProperties(AnnotationAttributes enableGemFireHttpSessionAttributes) {
        boolean defaultExposeConfigurationAsProperties = Boolean.TRUE.equals(enableGemFireHttpSessionAttributes.getBoolean("exposeConfigurationAsProperties"));
        this.setExposeConfigurationAsProperties(this.resolveProperty(this.exposeConfigurationAsPropertiesPropertyName(), defaultExposeConfigurationAsProperties));
    }

    private void configureIndexedSessionAttributes(AnnotationAttributes enableGemFireHttpSessionAttributes) {
        String[] defaultIndexedSessionAttributes = enableGemFireHttpSessionAttributes.getStringArray("indexableSessionAttributes");
        this.setIndexableSessionAttributes(this.resolveProperty(this.indexedSessionAttributesPropertyName(), this.resolveProperty(this.indexableSessionAttributesPropertyName(), defaultIndexedSessionAttributes)));
    }

    private void configureMaxInactiveIntervalInSeconds(AnnotationAttributes enableGemFireHttpSessionAttributes) {
        Integer defaultMaxInactiveIntervalInSeconds = enableGemFireHttpSessionAttributes.getNumber("maxInactiveIntervalInSeconds").intValue();
        this.setMaxInactiveIntervalInSeconds(this.resolveProperty(this.maxInactiveIntervalInSecondsPropertyName(), defaultMaxInactiveIntervalInSeconds));
    }

    private void configurePoolName(AnnotationAttributes enableGemFireHttpSessionAttributes) {
        String defaultPoolName = enableGemFireHttpSessionAttributes.getString("poolName");
        this.setPoolName(this.resolveProperty(this.poolNamePropertyName(), defaultPoolName));
    }

    private void configureServerRegionShortcut(AnnotationAttributes enableGemFireHttpSessionAttributes) {
        RegionShortcut defaultServerRegionShortcut = (RegionShortcut)enableGemFireHttpSessionAttributes.getEnum("serverRegionShortcut");
        this.setServerRegionShortcut(this.resolveProperty(this.serverRegionShortcutPropertyName(), RegionShortcut.class, defaultServerRegionShortcut));
    }

    private void configureSessionExpirationPolicyBeanName(AnnotationAttributes enableGemFireHttpSessionAttributes) {
        String defaultSessionExpirationPolicyBeanName = enableGemFireHttpSessionAttributes.getString("sessionExpirationPolicyBeanName");
        this.setSessionExpirationPolicyBeanName(this.resolveProperty(this.sessionExpirationPolicyBeanNamePropertyName(), defaultSessionExpirationPolicyBeanName));
    }

    private void configureSessionRegionName(AnnotationAttributes enableGemFireHttpSessionAttributes) {
        String defaultSessionRegionName = enableGemFireHttpSessionAttributes.getString("regionName");
        this.setSessionRegionName(this.resolveProperty(this.sessionRegionNamePropertyName(), defaultSessionRegionName));
    }

    private void configureSessionSerializerBeanName(AnnotationAttributes enableGemFireHttpSessionAttributes) {
        String defaultSessionSerializerBeanName = enableGemFireHttpSessionAttributes.getString("sessionSerializerBeanName");
        this.setSessionSerializerBeanName(this.resolveProperty(this.sessionSerializerBeanNamePropertyName(), defaultSessionSerializerBeanName));
    }

    void applySpringSessionGemFireConfigurer() {
        this.resolveSpringSessionGemFireConfigurer().map(this::applyClientRegionShortcut).map(this::applyExposeConfigurationAsProperties).map(this::applyIndexableSessionAttributes).map(this::applyMaxInactiveIntervalInSeconds).map(this::applyPoolName).map(this::applyServerRegionShortcut).map(this::applySessionExpirationPolicyBeanName).map(this::applySessionRegionName).map(this::applySessionSerializerBeanName);
    }

    private Optional<SpringSessionGemFireConfigurer> resolveSpringSessionGemFireConfigurer() {
        try {
            return Optional.of(this.getApplicationContext().getBean(SpringSessionGemFireConfigurer.class));
        }
        catch (BeansException cause) {
            if (this.isCauseBecauseNoSpringSessionGemFireConfigurerPresent((Exception)((Object)cause))) {
                return Optional.empty();
            }
            throw cause;
        }
    }

    private boolean isCauseBecauseNoSpringSessionGemFireConfigurerPresent(Exception cause) {
        return !(cause instanceof NoUniqueBeanDefinitionException) && cause instanceof NoSuchBeanDefinitionException;
    }

    private <T> SpringSessionGemFireConfigurer applySpringSessionGemFireConfigurerConfiguration(@Nullable SpringSessionGemFireConfigurer configurer, @NonNull String methodName, @NonNull Function<SpringSessionGemFireConfigurer, T> getter, @NonNull Consumer<T> setter) {
        Optional.ofNullable(configurer).filter(it -> GemFireHttpSessionConfiguration.isOverriddenMethodPresent(configurer, methodName)).map(getter).ifPresent(setter);
        return configurer;
    }

    private SpringSessionGemFireConfigurer applyClientRegionShortcut(SpringSessionGemFireConfigurer configurer) {
        return this.applySpringSessionGemFireConfigurerConfiguration(configurer, CONFIGURER_GET_CLIENT_REGION_SHORTCUT_METHOD_NAME, SpringSessionGemFireConfigurer::getClientRegionShortcut, this::setClientRegionShortcut);
    }

    private <T> SpringSessionGemFireConfigurer applyExposeConfigurationAsProperties(SpringSessionGemFireConfigurer configurer) {
        return this.applySpringSessionGemFireConfigurerConfiguration(configurer, CONFIGURER_GET_EXPOSE_CONFIGURATION_IN_PROPERTIES_METHOD_NAME, SpringSessionGemFireConfigurer::getExposeConfigurationAsProperties, this::setExposeConfigurationAsProperties);
    }

    private SpringSessionGemFireConfigurer applyIndexableSessionAttributes(SpringSessionGemFireConfigurer configurer) {
        return this.applySpringSessionGemFireConfigurerConfiguration(configurer, CONFIGURER_GET_INDEXABLE_SESSION_ATTRIBUTES_METHOD_NAME, SpringSessionGemFireConfigurer::getIndexableSessionAttributes, this::setIndexableSessionAttributes);
    }

    private SpringSessionGemFireConfigurer applyMaxInactiveIntervalInSeconds(SpringSessionGemFireConfigurer configurer) {
        return this.applySpringSessionGemFireConfigurerConfiguration(configurer, CONFIGURER_GET_MAX_INACTIVE_INTERVAL_IN_SECONDS_METHOD_NAME, SpringSessionGemFireConfigurer::getMaxInactiveIntervalInSeconds, this::setMaxInactiveIntervalInSeconds);
    }

    private SpringSessionGemFireConfigurer applyPoolName(SpringSessionGemFireConfigurer configurer) {
        return this.applySpringSessionGemFireConfigurerConfiguration(configurer, CONFIGURER_GET_POOL_NAME_METHOD_NAME, SpringSessionGemFireConfigurer::getPoolName, this::setPoolName);
    }

    private SpringSessionGemFireConfigurer applyServerRegionShortcut(SpringSessionGemFireConfigurer configurer) {
        return this.applySpringSessionGemFireConfigurerConfiguration(configurer, CONFIGURER_GET_SERVER_REGION_SHORTCUT_METHOD_NAME, SpringSessionGemFireConfigurer::getServerRegionShortcut, this::setServerRegionShortcut);
    }

    private SpringSessionGemFireConfigurer applySessionExpirationPolicyBeanName(SpringSessionGemFireConfigurer configurer) {
        return this.applySpringSessionGemFireConfigurerConfiguration(configurer, CONFIGURER_GET_SESSION_EXPIRATION_POLICY_BEAN_NAME_METHOD_NAME, SpringSessionGemFireConfigurer::getSessionExpirationPolicyBeanName, this::setSessionExpirationPolicyBeanName);
    }

    private SpringSessionGemFireConfigurer applySessionRegionName(SpringSessionGemFireConfigurer configurer) {
        return this.applySpringSessionGemFireConfigurerConfiguration(configurer, CONFIGURER_GET_REGION_NAME_METHOD_NAME, SpringSessionGemFireConfigurer::getRegionName, this::setSessionRegionName);
    }

    private SpringSessionGemFireConfigurer applySessionSerializerBeanName(SpringSessionGemFireConfigurer configurer) {
        return this.applySpringSessionGemFireConfigurerConfiguration(configurer, CONFIGURER_GET_SESSION_SERIALIZER_BEAN_NAME_METHOD_NAME, SpringSessionGemFireConfigurer::getSessionSerializerBeanName, this::setSessionSerializerBeanName);
    }

    void exposeSpringSessionGemFireConfiguration() {
        if (this.isExposeConfigurationAsProperties()) {
            Optional.ofNullable(this.getEnvironment()).filter(ConfigurableEnvironment.class::isInstance).map(ConfigurableEnvironment.class::cast).map(ConfigurableEnvironment::getPropertySources).map(propertySources -> {
                Properties springSessionGemFireProperties = new Properties();
                PropertiesPropertySource springSessionGemFirePropertySource = new PropertiesPropertySource(SPRING_SESSION_GEMFIRE_PROPERTY_SOURCE, springSessionGemFireProperties);
                propertySources.addFirst((PropertySource)springSessionGemFirePropertySource);
                return springSessionGemFireProperties;
            }).ifPresent(properties -> {
                properties.setProperty(this.clientRegionShortcutPropertyName(), this.getClientRegionShortcut().name());
                properties.setProperty(this.exposeConfigurationAsPropertiesPropertyName(), String.valueOf(this.isExposeConfigurationAsProperties()));
                properties.setProperty(this.indexableSessionAttributesPropertyName(), StringUtils.arrayToCommaDelimitedString((Object[])this.getIndexableSessionAttributes()));
                properties.setProperty(this.indexedSessionAttributesPropertyName(), StringUtils.arrayToCommaDelimitedString((Object[])this.getIndexableSessionAttributes()));
                properties.setProperty(this.maxInactiveIntervalInSecondsPropertyName(), String.valueOf(this.getMaxInactiveIntervalInSeconds()));
                properties.setProperty(this.poolNamePropertyName(), this.getPoolName());
                properties.setProperty(this.sessionRegionNamePropertyName(), this.getSessionRegionName());
                properties.setProperty(this.serverRegionShortcutPropertyName(), this.getServerRegionShortcut().name());
                this.getSessionExpirationPolicyBeanName().ifPresent(it -> properties.setProperty(this.sessionExpirationPolicyBeanNamePropertyName(), (String)it));
                properties.setProperty(this.sessionSerializerBeanNamePropertyName(), this.getSessionSerializerBeanName());
            });
        }
    }

    @PostConstruct
    public void init() {
        this.getBeanFactory().registerAlias(this.getSessionSerializerBeanName(), SESSION_SERIALIZER_BEAN_ALIAS);
    }

    @Bean
    BeanPostProcessor sessionExpirationTimeoutAwareBeanPostProcessor() {
        Duration expirationTimeout = Duration.ofSeconds(this.getMaxInactiveIntervalInSeconds());
        return new SessionExpirationTimeoutAwareBeanPostProcessor(expirationTimeout);
    }

    @Bean
    BeanPostProcessor sessionSerializerConfigurationBeanPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof CacheFactoryBean) {
                    SessionSerializer sessionSerializer = GemFireHttpSessionConfiguration.this.resolveSessionSerializer();
                    GemFireHttpSessionConfiguration.this.configureSerialization((CacheFactoryBean)bean, sessionSerializer);
                }
                return bean;
            }
        };
    }

    private Optional<SessionExpirationPolicy> resolveSessionExpirationPolicy() {
        Optional<String> sessionExpirationPolicyBeanName = this.getSessionExpirationPolicyBeanName();
        if (sessionExpirationPolicyBeanName.isPresent()) {
            if (this.getApplicationContext().containsBean(sessionExpirationPolicyBeanName.get())) {
                return Optional.of(this.getApplicationContext().getBean(sessionExpirationPolicyBeanName.get(), SessionExpirationPolicy.class));
            }
            String logMessage = "No Bean with name [{}] and type [{}] was configured; Defaulting to Expiration policy configured for Region [{}]";
            this.getLogger().warn(logMessage, new Object[]{sessionExpirationPolicyBeanName.get(), SessionExpirationPolicy.class.getName(), this.getSessionRegionName()});
        }
        return Optional.empty();
    }

    private SessionSerializer resolveSessionSerializer() {
        return (SessionSerializer)this.getApplicationContext().getBean(SESSION_SERIALIZER_BEAN_ALIAS, SessionSerializer.class);
    }

    private boolean isDataSerializerSessionSerializerAdapterPresent() {
        return !ArrayUtils.isEmpty((Object[])this.getApplicationContext().getBeanNamesForType(DataSerializerSessionSerializerAdapter.class));
    }

    private void configureSerialization(CacheFactoryBean cacheFactoryBean, SessionSerializer sessionSerializer) {
        if (sessionSerializer instanceof DataSerializer) {
            if (sessionSerializer instanceof DataSerializableSessionSerializer) {
                DataSerializableSessionSerializer.register();
            } else {
                DataSerializer.register(sessionSerializer.getClass());
            }
            this.setUseDataSerialization(true);
        } else if (sessionSerializer instanceof PdxSerializer) {
            cacheFactoryBean.setPdxSerializer(ComposablePdxSerializer.compose((PdxSerializer)sessionSerializer, cacheFactoryBean.getPdxSerializer()));
        } else {
            Optional.ofNullable(sessionSerializer).filter(it -> !this.isDataSerializerSessionSerializerAdapterPresent()).ifPresent(serializer -> cacheFactoryBean.setPdxSerializer(ComposablePdxSerializer.compose(new PdxSerializerSessionSerializerAdapter(sessionSerializer), cacheFactoryBean.getPdxSerializer())));
        }
    }

    @Bean(value={"SessionDataSerializer"})
    public Object sessionDataSerializer() {
        return new DataSerializableSessionSerializer();
    }

    @Bean(value={"SessionPdxSerializer"})
    public Object sessionPdxSerializer() {
        return new PdxSerializableSessionSerializer();
    }

    @Bean(name={"ClusteredSpringSessions"})
    public SessionCacheTypeAwareRegionFactoryBean<Object, Session> sessionRegion(GemFireCache gemfireCache, @Qualifier(value="sessionRegionAttributes") RegionAttributes<Object, Session> sessionRegionAttributes) {
        SessionCacheTypeAwareRegionFactoryBean<Object, Session> sessionRegion = new SessionCacheTypeAwareRegionFactoryBean<Object, Session>();
        sessionRegion.setAttributes(sessionRegionAttributes);
        sessionRegion.setCache(gemfireCache);
        sessionRegion.setClientRegionShortcut(this.getClientRegionShortcut());
        sessionRegion.setPoolName(this.getPoolName());
        sessionRegion.setRegionName(this.getSessionRegionName());
        sessionRegion.setServerRegionShortcut(this.getServerRegionShortcut());
        return sessionRegion;
    }

    @Bean
    public RegionAttributesFactoryBean sessionRegionAttributes(GemFireCache gemfireCache) {
        RegionAttributesFactoryBean regionAttributes = new RegionAttributesFactoryBean();
        regionAttributes.setKeyConstraint(SESSION_REGION_KEY_CONSTRAINT);
        regionAttributes.setValueConstraint(SESSION_REGION_VALUE_CONSTRAINT);
        if (this.isExpirationAllowed(gemfireCache)) {
            regionAttributes.setStatisticsEnabled(true);
            regionAttributes.setEntryIdleTimeout(new ExpirationAttributes(Math.max(this.getMaxInactiveIntervalInSeconds(), 0), ExpirationAction.INVALIDATE));
            this.resolveSessionExpirationPolicy().map(SessionExpirationPolicyCustomExpiryAdapter::new).ifPresent(arg_0 -> ((RegionAttributesFactoryBean)regionAttributes).setCustomEntryIdleTimeout(arg_0));
        } else {
            this.getLogger().info("Expiration is not allowed on Regions with a data management policy of {}", GemfireUtils.isClient((GemFireCache)gemfireCache) ? this.getClientRegionShortcut() : this.getServerRegionShortcut());
        }
        return regionAttributes;
    }

    boolean isExpirationAllowed(GemFireCache gemfireCache) {
        return !(!GemFireUtils.isClient(gemfireCache) ? GemFireUtils.isProxy(this.getServerRegionShortcut()) : GemFireUtils.isProxy(this.getClientRegionShortcut()));
    }

    @Bean
    @DependsOn(value={"ClusteredSpringSessions"})
    public GemfireTemplate sessionRegionTemplate(GemFireCache gemfireCache) {
        return new GemfireTemplate(gemfireCache.getRegion(this.getSessionRegionName()));
    }

    @Bean
    public GemFireOperationsSessionRepository sessionRepository(@Qualifier(value="sessionRegionTemplate") GemfireOperations gemfireOperations) {
        GemFireOperationsSessionRepository sessionRepository = new GemFireOperationsSessionRepository(gemfireOperations);
        sessionRepository.setIsDirtyPredicate(this.getIsDirtyPredicate());
        sessionRepository.setMaxInactiveIntervalInSeconds(this.getMaxInactiveIntervalInSeconds());
        sessionRepository.setUseDataSerialization(this.isUsingDataSerialization());
        return sessionRepository;
    }

    @Bean
    @DependsOn(value={"ClusteredSpringSessions"})
    public IndexFactoryBean principalNameIndex(GemFireCache gemfireCache) {
        IndexFactoryBean principalNameIndex = new IndexFactoryBean();
        principalNameIndex.setCache((RegionService)gemfireCache);
        principalNameIndex.setName("principalNameIndex");
        principalNameIndex.setExpression("principalName");
        principalNameIndex.setFrom(RegionUtils.toRegionPath((String)this.getSessionRegionName()));
        principalNameIndex.setOverride(true);
        principalNameIndex.setType(IndexType.HASH);
        return principalNameIndex;
    }

    @Bean
    @DependsOn(value={"ClusteredSpringSessions"})
    public SessionAttributesIndexFactoryBean sessionAttributesIndex(GemFireCache gemfireCache) {
        SessionAttributesIndexFactoryBean sessionAttributesIndex = new SessionAttributesIndexFactoryBean();
        sessionAttributesIndex.setGemFireCache(gemfireCache);
        sessionAttributesIndex.setIndexableSessionAttributes(this.getIndexableSessionAttributes());
        sessionAttributesIndex.setRegionName(this.getSessionRegionName());
        return sessionAttributesIndex;
    }
}

