/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.savedrequest;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.Assert;

public class RequestCacheAdapter
implements RequestCache {
    private final RequestCache delegate;

    public RequestCacheAdapter() {
        this(new HttpSessionRequestCache());
    }

    public RequestCacheAdapter(RequestCache delegate) {
        Assert.notNull((Object)delegate, (String)"delegate cannot be null");
        this.delegate = delegate;
    }

    public void saveRequest(HttpServletRequest request, HttpServletResponse response) {
        this.delegate.saveRequest(request, response);
    }

    public SavedRequest getRequest(HttpServletRequest request, HttpServletResponse response) {
        SavedRequest result = this.delegate.getRequest(request, response);
        Cookie[] cookies = request.getCookies();
        return new SavedRequestAdapter(result, cookies == null ? null : Arrays.asList(cookies));
    }

    public HttpServletRequest getMatchingRequest(HttpServletRequest request, HttpServletResponse response) {
        return this.delegate.getMatchingRequest(request, response);
    }

    public void removeRequest(HttpServletRequest request, HttpServletResponse response) {
        this.delegate.removeRequest(request, response);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SavedRequestAdapter
    implements SavedRequest {
        private SavedRequest delegate;
        private List<Cookie> cookies;
        private static final long serialVersionUID = 1184951442151447331L;

        public SavedRequestAdapter(SavedRequest delegate, List<Cookie> cookies) {
            this.delegate = delegate;
            this.cookies = cookies;
        }

        @Override
        public String getRedirectUrl() {
            return this.delegate.getRedirectUrl();
        }

        @Override
        public List<Cookie> getCookies() {
            return this.cookies;
        }

        @Override
        public String getMethod() {
            return this.delegate.getMethod();
        }

        @Override
        public List<String> getHeaderValues(String name) {
            return this.delegate.getHeaderValues(name);
        }

        @Override
        public Collection<String> getHeaderNames() {
            return this.delegate.getHeaderNames();
        }

        @Override
        public List<Locale> getLocales() {
            return this.delegate.getLocales();
        }

        @Override
        public String[] getParameterValues(String name) {
            return this.delegate.getParameterValues(name);
        }

        @Override
        public Map<String, String[]> getParameterMap() {
            return this.delegate.getParameterMap();
        }
    }
}

