/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.DummyRequest;
import org.springframework.security.web.access.DummyResponse;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.springframework.util.Assert;

public class DefaultWebInvocationPrivilegeEvaluator
implements WebInvocationPrivilegeEvaluator {
    protected static final Log logger = LogFactory.getLog(DefaultWebInvocationPrivilegeEvaluator.class);
    static final FilterChain DUMMY_CHAIN = new FilterChain(){

        public void doFilter(ServletRequest req, ServletResponse res) throws IOException, ServletException {
            throw new UnsupportedOperationException("DefaultWebInvocationPrivilegeEvaluator does not support filter chains");
        }
    };
    static final HttpServletResponse DUMMY_RESPONSE = new DummyResponse();
    private AbstractSecurityInterceptor securityInterceptor;

    public DefaultWebInvocationPrivilegeEvaluator(AbstractSecurityInterceptor securityInterceptor) {
        Assert.notNull((Object)securityInterceptor, (String)"SecurityInterceptor cannot be null");
        Assert.isTrue((boolean)FilterInvocation.class.equals((Object)securityInterceptor.getSecureObjectClass()), (String)"AbstractSecurityInterceptor does not support FilterInvocations");
        Assert.notNull((Object)securityInterceptor.getAccessDecisionManager(), (String)"AbstractSecurityInterceptor must provide a non-null AccessDecisionManager");
        this.securityInterceptor = securityInterceptor;
    }

    public boolean isAllowed(String uri, Authentication authentication) {
        return this.isAllowed(null, uri, null, authentication);
    }

    public boolean isAllowed(String contextPath, String uri, String method, Authentication authentication) {
        Assert.notNull((Object)uri, (String)"uri parameter is required");
        if (contextPath == null) {
            contextPath = "/ctxpath";
        }
        FilterInvocation fi = this.createFilterInvocation(contextPath, uri, method);
        Collection attrs = this.securityInterceptor.obtainSecurityMetadataSource().getAttributes((Object)fi);
        if (attrs == null) {
            return !this.securityInterceptor.isRejectPublicInvocations();
        }
        if (authentication == null || authentication.getAuthorities() == null || authentication.getAuthorities().isEmpty()) {
            return false;
        }
        try {
            this.securityInterceptor.getAccessDecisionManager().decide(authentication, (Object)fi, attrs);
        }
        catch (AccessDeniedException unauthorized) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(fi.toString() + " denied for " + authentication.toString()), (Throwable)unauthorized);
            }
            return false;
        }
        return true;
    }

    private FilterInvocation createFilterInvocation(String contextPath, String uri, String method) {
        Assert.hasText((String)contextPath, (String)"contextPath required");
        Assert.hasText((String)uri, (String)"URI required");
        DummyRequest req = new DummyRequest();
        req.setRequestURI(contextPath + uri);
        req.setContextPath(contextPath);
        req.setServletPath(null);
        req.setMethod(method);
        return new FilterInvocation((ServletRequest)req, (ServletResponse)DUMMY_RESPONSE, DUMMY_CHAIN);
    }
}

