package org.springframework.security.web.util;

/**
 * Utility for escaping characters in HTML strings.
 *
 * @author Luke Taylor
 * @version $Id: TextEscapeUtils.java 3607 2009-04-25 08:04:26Z ltaylor $
 */
public abstract class TextEscapeUtils {

    public final static String escapeEntities(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }

        StringBuffer sb = new StringBuffer();

        for (int i=0; i < s.length(); i++) {
            char c = s.charAt(i);

            if(c == '<') {
                sb.append("&lt;");
            } else if (c == '>') {
                sb.append("&gt;");
            } else if (c == '"') {
                sb.append("&#034;");
            } else if (c == '\'') {
                sb.append("&#039;");
            } else if (c == '&') {
                sb.append("&amp;");
            } else {
                sb.append(c);
            }
        }

        return sb.toString();
    }

}
