/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.SpringSecurityFilter;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.util.Assert;

public abstract class AbstractPreAuthenticatedProcessingFilter
extends SpringSecurityFilter
implements InitializingBean,
ApplicationEventPublisherAware {
    private ApplicationEventPublisher eventPublisher = null;
    private AuthenticationDetailsSource authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private AuthenticationManager authenticationManager = null;
    private boolean continueFilterChainOnUnsuccessfulAuthentication = true;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"An AuthenticationManager must be set");
    }

    public void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Checking secure context token: " + SecurityContextHolder.getContext().getAuthentication()));
        }
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            this.doAuthenticate(request, response);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void doAuthenticate(HttpServletRequest request, HttpServletResponse response) {
        block5: {
            Authentication authResult = null;
            Object principal = this.getPreAuthenticatedPrincipal(request);
            Object credentials = this.getPreAuthenticatedCredentials(request);
            if (principal == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"No pre-authenticated principal found in request");
                }
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("preAuthenticatedPrincipal = " + principal + ", trying to authenticate"));
            }
            try {
                PreAuthenticatedAuthenticationToken authRequest = new PreAuthenticatedAuthenticationToken(principal, credentials);
                authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
                authResult = this.authenticationManager.authenticate((Authentication)authRequest);
                this.successfulAuthentication(request, response, authResult);
            }
            catch (AuthenticationException failed) {
                this.unsuccessfulAuthentication(request, response, failed);
                if (this.continueFilterChainOnUnsuccessfulAuthentication) break block5;
                throw failed;
            }
        }
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authentication success: " + authResult));
        }
        SecurityContextHolder.getContext().setAuthentication(authResult);
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent((ApplicationEvent)new InteractiveAuthenticationSuccessEvent(authResult, this.getClass()));
        }
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) {
        SecurityContextHolder.clearContext();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Cleared security context due to exception", (Throwable)failed);
        }
        request.getSession().setAttribute("SPRING_SECURITY_LAST_EXCEPTION", (Object)failed);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher anApplicationEventPublisher) {
        this.eventPublisher = anApplicationEventPublisher;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource authenticationDetailsSource) {
        Assert.notNull((Object)authenticationDetailsSource, (String)"AuthenticationDetailsSource required");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setContinueFilterChainOnUnsuccessfulAuthentication(boolean shouldContinue) {
        this.continueFilterChainOnUnsuccessfulAuthentication = shouldContinue;
    }

    protected abstract Object getPreAuthenticatedPrincipal(HttpServletRequest var1);

    protected abstract Object getPreAuthenticatedCredentials(HttpServletRequest var1);
}

