/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.security.web.util.RedirectUtils;
import org.springframework.util.StringUtils;

public class SavedRequestAwareAuthenticationSuccessHandler
extends SimpleUrlAuthenticationSuccessHandler {
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        SavedRequest savedRequest = this.getSavedRequest(request);
        if (savedRequest == null) {
            super.onAuthenticationSuccess(request, response, authentication);
            return;
        }
        if (this.isAlwaysUseDefaultTargetUrl() || StringUtils.hasText((String)request.getParameter(this.getTargetUrlParameter()))) {
            this.removeSavedRequest(request);
            super.onAuthenticationSuccess(request, response, authentication);
            return;
        }
        String targetUrl = savedRequest.getFullRequestUrl();
        this.logger.debug((Object)("Redirecting to SavedRequest Url: " + targetUrl));
        RedirectUtils.sendRedirect(request, response, targetUrl, this.isUseRelativeContext());
    }

    private SavedRequest getSavedRequest(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            return (SavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY");
        }
        return null;
    }

    private void removeSavedRequest(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            this.logger.debug((Object)"Removing SavedRequest from session if present");
            session.removeAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY");
        }
    }
}

