/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.servlet.filter;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.saml2.provider.service.authentication.OpenSamlAuthenticationRequestFactory;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequestContext;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequestFactory;
import org.springframework.security.saml2.provider.service.authentication.Saml2PostAuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2RedirectAuthenticationRequest;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.security.saml2.provider.service.servlet.filter.Saml2ServletUtils;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public class Saml2WebSsoAuthenticationRequestFilter
extends OncePerRequestFilter {
    private final RelyingPartyRegistrationRepository relyingPartyRegistrationRepository;
    private RequestMatcher redirectMatcher = new AntPathRequestMatcher("/saml2/authenticate/{registrationId}");
    private Saml2AuthenticationRequestFactory authenticationRequestFactory = new OpenSamlAuthenticationRequestFactory();

    public Saml2WebSsoAuthenticationRequestFilter(RelyingPartyRegistrationRepository relyingPartyRegistrationRepository) {
        Assert.notNull((Object)relyingPartyRegistrationRepository, (String)"relyingPartyRegistrationRepository cannot be null");
        this.relyingPartyRegistrationRepository = relyingPartyRegistrationRepository;
    }

    public void setAuthenticationRequestFactory(Saml2AuthenticationRequestFactory authenticationRequestFactory) {
        Assert.notNull((Object)authenticationRequestFactory, (String)"authenticationRequestFactory cannot be null");
        this.authenticationRequestFactory = authenticationRequestFactory;
    }

    public void setRedirectMatcher(RequestMatcher redirectMatcher) {
        Assert.notNull((Object)redirectMatcher, (String)"redirectMatcher cannot be null");
        this.redirectMatcher = redirectMatcher;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        RequestMatcher.MatchResult matcher = this.redirectMatcher.matcher(request);
        if (!matcher.isMatch()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String registrationId = (String)matcher.getVariables().get("registrationId");
        RelyingPartyRegistration relyingParty = this.relyingPartyRegistrationRepository.findByRegistrationId(registrationId);
        if (relyingParty == null) {
            response.sendError(401);
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Creating SAML2 SP Authentication Request for IDP[%s]", relyingParty.getRegistrationId()));
        }
        Saml2AuthenticationRequestContext authnRequestCtx = this.createRedirectAuthenticationRequestContext(relyingParty, request);
        if (relyingParty.getProviderDetails().getBinding() == Saml2MessageBinding.REDIRECT) {
            this.sendRedirect(response, authnRequestCtx);
        } else {
            this.sendPost(response, authnRequestCtx);
        }
    }

    private void sendRedirect(HttpServletResponse response, Saml2AuthenticationRequestContext authnRequestCtx) throws IOException {
        String redirectUrl = this.createSamlRequestRedirectUrl(authnRequestCtx);
        response.sendRedirect(redirectUrl);
    }

    private void sendPost(HttpServletResponse response, Saml2AuthenticationRequestContext authnRequestCtx) throws IOException {
        Saml2PostAuthenticationRequest authNData = this.authenticationRequestFactory.createPostAuthenticationRequest(authnRequestCtx);
        String html = this.createSamlPostRequestFormData(authNData);
        response.setContentType("text/html");
        response.getWriter().write(html);
    }

    private String createSamlRequestRedirectUrl(Saml2AuthenticationRequestContext authnRequestCtx) {
        Saml2RedirectAuthenticationRequest authNData = this.authenticationRequestFactory.createRedirectAuthenticationRequest(authnRequestCtx);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)authNData.getAuthenticationRequestUri());
        this.addParameter("SAMLRequest", authNData.getSamlRequest(), uriBuilder);
        this.addParameter("RelayState", authNData.getRelayState(), uriBuilder);
        this.addParameter("SigAlg", authNData.getSigAlg(), uriBuilder);
        this.addParameter("Signature", authNData.getSignature(), uriBuilder);
        return uriBuilder.build(true).toUriString();
    }

    private void addParameter(String name, String value, UriComponentsBuilder builder) {
        Assert.hasText((String)name, (String)"name cannot be empty or null");
        if (StringUtils.hasText((String)value)) {
            builder.queryParam(UriUtils.encode((String)name, (Charset)StandardCharsets.ISO_8859_1), new Object[]{UriUtils.encode((String)value, (Charset)StandardCharsets.ISO_8859_1)});
        }
    }

    private Saml2AuthenticationRequestContext createRedirectAuthenticationRequestContext(RelyingPartyRegistration relyingParty, HttpServletRequest request) {
        String applicationUri = Saml2ServletUtils.getApplicationUri(request);
        Function<String, String> resolver = this.templateResolver(applicationUri, relyingParty);
        String localSpEntityId = resolver.apply(relyingParty.getLocalEntityIdTemplate());
        String assertionConsumerServiceUrl = resolver.apply(relyingParty.getAssertionConsumerServiceUrlTemplate());
        return Saml2AuthenticationRequestContext.builder().issuer(localSpEntityId).relyingPartyRegistration(relyingParty).assertionConsumerServiceUrl(assertionConsumerServiceUrl).relayState(request.getParameter("RelayState")).build();
    }

    private Function<String, String> templateResolver(String applicationUri, RelyingPartyRegistration relyingParty) {
        return template -> Saml2ServletUtils.resolveUrlTemplate(template, applicationUri, relyingParty);
    }

    private String htmlEscape(String value) {
        if (StringUtils.hasText((String)value)) {
            return HtmlUtils.htmlEscape((String)value);
        }
        return value;
    }

    private String createSamlPostRequestFormData(Saml2PostAuthenticationRequest request) {
        String destination = request.getAuthenticationRequestUri();
        String relayState = this.htmlEscape(request.getRelayState());
        String samlRequest = this.htmlEscape(request.getSamlRequest());
        StringBuilder postHtml = new StringBuilder().append("<!DOCTYPE html>\n").append("<html>\n").append("    <head>\n").append("        <meta charset=\"utf-8\" />\n").append("    </head>\n").append("    <body onload=\"document.forms[0].submit()\">\n").append("        <noscript>\n").append("            <p>\n").append("                <strong>Note:</strong> Since your browser does not support JavaScript,\n").append("                you must press the Continue button once to proceed.\n").append("            </p>\n").append("        </noscript>\n").append("        \n").append("        <form action=\"").append(destination).append("\" method=\"post\">\n").append("            <div>\n").append("                <input type=\"hidden\" name=\"SAMLRequest\" value=\"").append(samlRequest).append("\"/>\n");
        if (StringUtils.hasText((String)relayState)) {
            postHtml.append("                <input type=\"hidden\" name=\"RelayState\" value=\"").append(relayState).append("\"/>\n");
        }
        postHtml.append("            </div>\n").append("            <noscript>\n").append("                <div>\n").append("                    <input type=\"submit\" value=\"Continue\"/>\n").append("                </div>\n").append("            </noscript>\n").append("        </form>\n").append("        \n").append("    </body>\n").append("</html>");
        return postHtml.toString();
    }
}

