/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.log.LogMessage;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;

public final class ExpressionJwtGrantedAuthoritiesConverter
implements Converter<Jwt, Collection<GrantedAuthority>> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private String authorityPrefix = "SCOPE_";
    private final Expression authoritiesClaimExpression;

    public ExpressionJwtGrantedAuthoritiesConverter(Expression authoritiesClaimExpression) {
        Assert.notNull((Object)authoritiesClaimExpression, (String)"authoritiesClaimExpression must not be null");
        this.authoritiesClaimExpression = authoritiesClaimExpression;
    }

    public void setAuthorityPrefix(String authorityPrefix) {
        Assert.notNull((Object)authorityPrefix, (String)"authorityPrefix cannot be null");
        this.authorityPrefix = authorityPrefix;
    }

    public Collection<GrantedAuthority> convert(Jwt jwt) {
        ArrayList<GrantedAuthority> grantedAuthorities = new ArrayList<GrantedAuthority>();
        for (String authority : this.getAuthorities(jwt)) {
            grantedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(this.authorityPrefix + authority));
        }
        return grantedAuthorities;
    }

    private Collection<String> getAuthorities(Jwt jwt) {
        Object authorities;
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)LogMessage.format((String)"Looking for authorities with expression. expression=%s", (Object)this.authoritiesClaimExpression.getExpressionString()));
            }
            authorities = this.authoritiesClaimExpression.getValue((Object)jwt.getClaims(), Collection.class);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)LogMessage.format((String)"Found authorities with expression. authorities=%s", (Object)authorities));
            }
        }
        catch (ExpressionException ee) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)LogMessage.format((String)"Failed to evaluate expression. error=%s", (Object)ee.getMessage()));
            }
            authorities = Collections.emptyList();
        }
        if (authorities != null) {
            return this.castAuthoritiesToCollection(authorities);
        }
        return Collections.emptyList();
    }

    private Collection<String> castAuthoritiesToCollection(Object authorities) {
        return (Collection)authorities;
    }
}

