/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token;

import java.util.Date;
import java.util.Set;
import java.util.UUID;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.ExpiringOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomValueTokenServices
implements AuthorizationServerTokenServices,
ResourceServerTokenServices,
InitializingBean {
    private int refreshTokenValiditySeconds = 2592000;
    private int accessTokenValiditySeconds = 43200;
    private boolean supportRefreshToken = false;
    private boolean reuseRefreshToken = true;
    private TokenStore tokenStore;
    private ClientDetailsService clientDetailsService;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.tokenStore, (String)"tokenStore must be set");
    }

    @Override
    public OAuth2AccessToken createAccessToken(OAuth2Authentication authentication) throws AuthenticationException {
        OAuth2AccessToken existingAccessToken = this.tokenStore.getAccessToken(authentication);
        if (existingAccessToken != null) {
            if (existingAccessToken.isExpired()) {
                this.tokenStore.removeAccessToken(existingAccessToken.getValue());
            } else {
                return existingAccessToken;
            }
        }
        ExpiringOAuth2RefreshToken refreshToken = null;
        if (this.supportRefreshToken) {
            refreshToken = this.createRefreshToken(authentication);
        }
        OAuth2AccessToken accessToken = this.createAccessToken(authentication, refreshToken);
        this.tokenStore.storeAccessToken(accessToken, authentication);
        return accessToken;
    }

    @Override
    public OAuth2AccessToken refreshAccessToken(String refreshTokenValue, Set<String> scope) throws AuthenticationException {
        if (!this.supportRefreshToken) {
            throw new InvalidGrantException("Invalid refresh token: " + refreshTokenValue);
        }
        this.tokenStore.removeAccessTokenUsingRefreshToken(refreshTokenValue);
        ExpiringOAuth2RefreshToken refreshToken = this.tokenStore.readRefreshToken(refreshTokenValue);
        if (refreshToken == null) {
            throw new InvalidGrantException("Invalid refresh token: " + refreshTokenValue);
        }
        if (this.isExpired(refreshToken)) {
            this.tokenStore.removeRefreshToken(refreshTokenValue);
            throw new InvalidGrantException("Invalid refresh token: " + refreshToken);
        }
        OAuth2Authentication authentication = this.createRefreshedAuthentication(this.tokenStore.readAuthentication(refreshToken), scope);
        if (!this.reuseRefreshToken) {
            this.tokenStore.removeRefreshToken(refreshTokenValue);
            refreshToken = this.createRefreshToken(authentication);
        }
        OAuth2AccessToken accessToken = this.createAccessToken(authentication, refreshToken);
        this.tokenStore.storeAccessToken(accessToken, authentication);
        return accessToken;
    }

    @Override
    public OAuth2AccessToken getAccessToken(OAuth2Authentication authentication) {
        return this.tokenStore.getAccessToken(authentication);
    }

    private OAuth2Authentication createRefreshedAuthentication(OAuth2Authentication authentication, Set<String> scope) {
        OAuth2Authentication narrowed = authentication;
        if (scope != null && !scope.isEmpty()) {
            AuthorizationRequest clientAuth = authentication.getAuthorizationRequest();
            Set<String> originalScope = clientAuth.getScope();
            if (originalScope == null || !originalScope.containsAll(scope)) {
                throw new InvalidScopeException("Unable to narrow the scope of the client authentication to " + scope + ".", originalScope);
            }
            narrowed = new OAuth2Authentication(clientAuth, authentication.getUserAuthentication());
        }
        return narrowed;
    }

    protected boolean isExpired(ExpiringOAuth2RefreshToken refreshToken) {
        return refreshToken.getExpiration() == null || System.currentTimeMillis() > refreshToken.getExpiration().getTime();
    }

    @Override
    public OAuth2Authentication loadAuthentication(String accessTokenValue) throws AuthenticationException {
        OAuth2AccessToken accessToken = this.tokenStore.readAccessToken(accessTokenValue);
        if (accessToken == null) {
            throw new InvalidTokenException("Invalid access token: " + accessTokenValue);
        }
        if (accessToken.isExpired()) {
            this.tokenStore.removeAccessToken(accessTokenValue);
            throw new InvalidTokenException("Invalid access token: " + accessTokenValue);
        }
        return this.tokenStore.readAuthentication(accessToken);
    }

    protected ExpiringOAuth2RefreshToken createRefreshToken(OAuth2Authentication authentication) {
        String refreshTokenValue = UUID.randomUUID().toString();
        ExpiringOAuth2RefreshToken refreshToken = new ExpiringOAuth2RefreshToken(refreshTokenValue, new Date(System.currentTimeMillis() + (long)this.refreshTokenValiditySeconds * 1000L));
        this.tokenStore.storeRefreshToken(refreshToken, authentication);
        return refreshToken;
    }

    protected OAuth2AccessToken createAccessToken(OAuth2Authentication authentication, OAuth2RefreshToken refreshToken) {
        String tokenValue = UUID.randomUUID().toString();
        OAuth2AccessToken token = new OAuth2AccessToken(tokenValue);
        int validitySeconds = this.getAccessTokenValiditySeconds(authentication.getAuthorizationRequest());
        if (validitySeconds > 0) {
            token.setExpiration(new Date(System.currentTimeMillis() + (long)validitySeconds * 1000L));
        }
        token.setRefreshToken(refreshToken);
        token.setScope(authentication.getAuthorizationRequest().getScope());
        return token;
    }

    protected int getAccessTokenValiditySeconds(AuthorizationRequest authorizationRequest) {
        ClientDetails client;
        if (this.clientDetailsService != null && (client = this.clientDetailsService.loadClientByClientId(authorizationRequest.getClientId())).getAccessTokenValiditySeconds() > 0) {
            return client.getAccessTokenValiditySeconds();
        }
        return this.accessTokenValiditySeconds;
    }

    public void setRefreshTokenValiditySeconds(int refreshTokenValiditySeconds) {
        this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
    }

    public void setAccessTokenValiditySeconds(int accessTokenValiditySeconds) {
        this.accessTokenValiditySeconds = accessTokenValiditySeconds;
    }

    public void setSupportRefreshToken(boolean supportRefreshToken) {
        this.supportRefreshToken = supportRefreshToken;
    }

    public void setReuseRefreshToken(boolean reuseRefreshToken) {
        this.reuseRefreshToken = reuseRefreshToken;
    }

    public void setTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }
}

