/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token;

import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.security.oauth2.common.ExpiringOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.AuthenticationKeyGenerator;
import org.springframework.security.oauth2.provider.token.DefaultAuthenticationKeyGenerator;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.util.Assert;

public class InMemoryTokenStore
implements TokenStore {
    private static final int DEFAULT_FLUSH_INTERVAL = 1000;
    private final ConcurrentHashMap<String, OAuth2AccessToken> accessTokenStore = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, OAuth2AccessToken> authenticationToAccessTokenStore = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ExpiringOAuth2RefreshToken> refreshTokenStore = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> accessTokenToRefreshTokenStore = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, OAuth2Authentication> authenticationStore = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> refreshTokenToAcessTokenStore = new ConcurrentHashMap();
    private final DelayQueue<TokenExpiry> expiryQueue = new DelayQueue();
    private int flushInterval = 1000;
    private AuthenticationKeyGenerator authenticationKeyGenerator = new DefaultAuthenticationKeyGenerator();
    private AtomicInteger flushCounter = new AtomicInteger(0);

    public void setFlushInterval(int flushInterval) {
        this.flushInterval = flushInterval;
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    public void clear() {
        this.accessTokenStore.clear();
        this.authenticationToAccessTokenStore.clear();
        this.refreshTokenStore.clear();
        this.accessTokenToRefreshTokenStore.clear();
        this.authenticationStore.clear();
        this.refreshTokenToAcessTokenStore.clear();
        this.expiryQueue.clear();
    }

    public void setAuthenticationKeyGenerator(AuthenticationKeyGenerator authenticationKeyGenerator) {
        this.authenticationKeyGenerator = authenticationKeyGenerator;
    }

    public int getAccessTokenCount() {
        Assert.state((this.accessTokenStore.isEmpty() || this.accessTokenStore.size() >= this.accessTokenToRefreshTokenStore.size() ? 1 : 0) != 0, (String)"Too many refresh tokens");
        Assert.state((this.accessTokenStore.size() == this.authenticationToAccessTokenStore.size() ? 1 : 0) != 0, (String)"Inconsistent token store state");
        Assert.state((this.accessTokenStore.size() <= this.authenticationStore.size() ? 1 : 0) != 0, (String)"Inconsistent authentication store state");
        return this.accessTokenStore.size();
    }

    public int getRefreshTokenCount() {
        Assert.state((this.refreshTokenStore.size() == this.refreshTokenToAcessTokenStore.size() ? 1 : 0) != 0, (String)"Inconsistent refresh token store state");
        return this.accessTokenStore.size();
    }

    public OAuth2AccessToken getAccessToken(OAuth2Authentication authentication) {
        OAuth2AccessToken accessToken = this.authenticationToAccessTokenStore.get(this.authenticationKeyGenerator.extractKey(authentication));
        if (accessToken != null && !authentication.equals((Object)this.readAuthentication(accessToken))) {
            this.storeAccessToken(accessToken, authentication);
        }
        return accessToken;
    }

    public OAuth2Authentication readAuthentication(OAuth2AccessToken token) {
        return this.authenticationStore.get(token.getValue());
    }

    public void storeAccessToken(OAuth2AccessToken token, OAuth2Authentication authentication) {
        if (this.flushCounter.incrementAndGet() >= this.flushInterval) {
            this.flush();
            this.flushCounter.set(0);
        }
        this.accessTokenStore.put(token.getValue(), token);
        this.authenticationStore.put(token.getValue(), authentication);
        this.authenticationToAccessTokenStore.put(this.authenticationKeyGenerator.extractKey(authentication), token);
        if (token.getExpiration() != null) {
            this.expiryQueue.put(new TokenExpiry(token.getValue(), token.getExpiration()));
        }
        if (token.getRefreshToken() != null && token.getRefreshToken().getValue() != null) {
            this.refreshTokenToAcessTokenStore.put(token.getRefreshToken().getValue(), token.getValue());
            this.accessTokenToRefreshTokenStore.put(token.getValue(), token.getRefreshToken().getValue());
        }
    }

    public OAuth2AccessToken readAccessToken(String tokenValue) {
        return this.accessTokenStore.get(tokenValue);
    }

    public void removeAccessToken(String tokenValue) {
        OAuth2Authentication authentication;
        this.accessTokenStore.remove(tokenValue);
        String refresh = this.accessTokenToRefreshTokenStore.remove(tokenValue);
        if (refresh != null) {
            this.refreshTokenStore.remove(tokenValue);
            this.refreshTokenToAcessTokenStore.remove(tokenValue);
        }
        if ((authentication = this.authenticationStore.remove(tokenValue)) != null) {
            this.authenticationToAccessTokenStore.remove(this.authenticationKeyGenerator.extractKey(authentication));
        }
    }

    public OAuth2Authentication readAuthentication(ExpiringOAuth2RefreshToken token) {
        return this.authenticationStore.get(token.getValue());
    }

    public void storeRefreshToken(ExpiringOAuth2RefreshToken refreshToken, OAuth2Authentication authentication) {
        this.refreshTokenStore.put(refreshToken.getValue(), refreshToken);
        this.authenticationStore.put(refreshToken.getValue(), authentication);
    }

    public ExpiringOAuth2RefreshToken readRefreshToken(String tokenValue) {
        return this.refreshTokenStore.get(tokenValue);
    }

    public void removeRefreshToken(String tokenValue) {
        this.refreshTokenStore.remove(tokenValue);
        this.authenticationStore.remove(tokenValue);
    }

    public void removeAccessTokenUsingRefreshToken(String refreshToken) {
        String accessToken = this.refreshTokenToAcessTokenStore.remove(refreshToken);
        if (accessToken != null) {
            this.accessTokenStore.remove(accessToken);
            this.authenticationStore.remove(accessToken);
        }
    }

    private void flush() {
        TokenExpiry expiry = (TokenExpiry)this.expiryQueue.poll();
        while (expiry != null) {
            this.removeAccessToken(expiry.getValue());
            expiry = (TokenExpiry)this.expiryQueue.poll();
        }
    }

    private static class TokenExpiry
    implements Delayed {
        private final long expiry;
        private final String value;

        public TokenExpiry(String value, Date date) {
            this.value = value;
            this.expiry = date.getTime();
        }

        public int compareTo(Delayed other) {
            if (this == other) {
                return 0;
            }
            long diff = this.getDelay(TimeUnit.MILLISECONDS) - other.getDelay(TimeUnit.MILLISECONDS);
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        }

        public long getDelay(TimeUnit unit) {
            return this.expiry - System.currentTimeMillis();
        }

        public String getValue() {
            return this.value;
        }
    }
}

