/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.error.DefaultProviderExceptionHandler;
import org.springframework.security.oauth2.provider.error.ProviderExceptionHandler;
import org.springframework.security.oauth2.provider.web.DefaultOAuth2ExceptionRenderer;
import org.springframework.security.oauth2.provider.web.OAuth2ExceptionRenderer;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.filter.GenericFilterBean;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;

public class OAuth2ExceptionHandlerFilter
extends GenericFilterBean {
    private ProviderExceptionHandler providerExceptionHandler = new DefaultProviderExceptionHandler();
    private DefaultHandlerExceptionResolver exceptionResolver = new DefaultHandlerExceptionResolver();
    private OAuth2ExceptionRenderer exceptionRenderer = new DefaultOAuth2ExceptionRenderer();

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Chain processed normally");
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            try {
                ResponseEntity<OAuth2Exception> result = this.providerExceptionHandler.handle(ex);
                this.exceptionRenderer.handleHttpEntityResponse((HttpEntity<?>)result, new ServletWebRequest(request, response));
                response.flushBuffer();
            }
            catch (ServletException e) {
                if (this.exceptionResolver.resolveException(request, response, (Object)this, (Exception)((Object)e)) == null) {
                    throw e;
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setProviderExceptionHandler(ProviderExceptionHandler providerExceptionHandler) {
        this.providerExceptionHandler = providerExceptionHandler;
    }

    public void setExceptionRenderer(OAuth2ExceptionRenderer exceptionRenderer) {
        this.exceptionRenderer = exceptionRenderer;
    }
}

