/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.error;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.DefaultThrowableAnalyzer;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.error.ProviderExceptionHandler;
import org.springframework.security.web.util.ThrowableAnalyzer;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProviderExceptionHandler
implements ProviderExceptionHandler {
    private static final Log logger = LogFactory.getLog(DefaultProviderExceptionHandler.class);
    private ThrowableAnalyzer throwableAnalyzer = new DefaultThrowableAnalyzer();

    @Override
    public ResponseEntity<OAuth2Exception> handle(Exception e) throws Exception {
        Throwable[] causeChain = this.throwableAnalyzer.determineCauseChain((Throwable)e);
        AuthenticationException ase = (AuthenticationException)this.throwableAnalyzer.getFirstThrowableOfType(AuthenticationException.class, causeChain);
        if (ase == null) {
            ase = (AccessDeniedException)this.throwableAnalyzer.getFirstThrowableOfType(AccessDeniedException.class, causeChain);
        }
        if (ase instanceof OAuth2Exception) {
            return this.handleSecurityException((OAuth2Exception)ase);
        }
        throw e;
    }

    private ResponseEntity<OAuth2Exception> handleSecurityException(OAuth2Exception e) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"OAuth error.", (Throwable)((Object)e));
        }
        int status = e.getHttpErrorCode();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Cache-Control", "no-store");
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("WWW-Authenticate", String.format("%s, %s", OAuth2AccessToken.BEARER_TYPE, e.getSummary()));
        ResponseEntity response = new ResponseEntity((Object)e, (MultiValueMap)headers, HttpStatus.valueOf((int)status));
        return response;
    }

    public void setThrowableAnalyzer(ThrowableAnalyzer throwableAnalyzer) {
        this.throwableAnalyzer = throwableAnalyzer;
    }
}

