/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.endpoint;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.HttpEntity;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.error.DefaultProviderExceptionHandler;
import org.springframework.security.oauth2.provider.error.ProviderExceptionHandler;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.ServletWebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractEndpoint
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ProviderExceptionHandler providerExceptionHandler = new DefaultProviderExceptionHandler();
    private TokenGranter tokenGranter;

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.tokenGranter != null ? 1 : 0) != 0, (String)"TokenGranter must be provided");
    }

    public void setProviderExceptionHandler(ProviderExceptionHandler providerExceptionHandler) {
        this.providerExceptionHandler = providerExceptionHandler;
    }

    public void setTokenGranter(TokenGranter tokenGranter) {
        this.tokenGranter = tokenGranter;
    }

    protected TokenGranter getTokenGranter() {
        return this.tokenGranter;
    }

    @ExceptionHandler(value={OAuth2Exception.class})
    public HttpEntity<OAuth2Exception> handleException(OAuth2Exception e, ServletWebRequest webRequest) throws Exception {
        return this.providerExceptionHandler.handle((Exception)((Object)e));
    }
}

