/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.token;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessTokenRequest
implements MultiValueMap<String, String> {
    private final MultiValueMap<String, String> parameters;
    private Object state;
    private OAuth2AccessToken existingToken;
    private String currentUri;

    public AccessTokenRequest() {
        this((LinkedMultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    public AccessTokenRequest(LinkedMultiValueMap<String, String> parameters) {
        this.parameters = parameters;
    }

    public AccessTokenRequest(Map<String, String[]> parameters) {
        this();
        for (String key : parameters.keySet()) {
            ArrayList<String> values = new ArrayList<String>();
            for (String value : parameters.get(key)) {
                values.add(value);
            }
            this.parameters.put((Object)key, values);
        }
    }

    public boolean isError() {
        return this.parameters.containsKey((Object)"error");
    }

    public Object getPreservedState() {
        return this.state;
    }

    public void setPreservedState(Object state) {
        this.state = state;
    }

    public String getStateKey() {
        return this.getFirst("state");
    }

    public void setStateKey(String state) {
        this.parameters.set((Object)"state", (Object)state);
    }

    public String getCurrentUri() {
        return this.currentUri;
    }

    public void setCurrentUri(String uri) {
        this.currentUri = uri;
    }

    public String getAuthorizationCode() {
        return this.getFirst("code");
    }

    public void setAuthorizationCode(String code) {
        this.parameters.set((Object)"code", (Object)code);
    }

    public void setExistingToken(OAuth2AccessToken existingToken) {
        this.existingToken = existingToken;
    }

    public OAuth2AccessToken getExistingToken() {
        return this.existingToken;
    }

    public String getFirst(String key) {
        return (String)this.parameters.getFirst((Object)key);
    }

    public void add(String key, String value) {
        this.parameters.add((Object)key, (Object)value);
    }

    public void set(String key, String value) {
        this.parameters.set((Object)key, (Object)value);
    }

    public void setAll(Map<String, String> values) {
        this.parameters.setAll(values);
    }

    public Map<String, String> toSingleValueMap() {
        return this.parameters.toSingleValueMap();
    }

    public int size() {
        return this.parameters.size();
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.parameters.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.parameters.containsValue(value);
    }

    public List<String> get(Object key) {
        return (List)this.parameters.get(key);
    }

    public List<String> put(String key, List<String> value) {
        return (List)this.parameters.put((Object)key, value);
    }

    public List<String> remove(Object key) {
        return (List)this.parameters.remove(key);
    }

    public void putAll(Map<? extends String, ? extends List<String>> m) {
        this.parameters.putAll(m);
    }

    public void clear() {
        this.parameters.clear();
    }

    public Set<String> keySet() {
        return this.parameters.keySet();
    }

    public Collection<List<String>> values() {
        return this.parameters.values();
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.parameters.entrySet();
    }

    public boolean equals(Object o) {
        return this.parameters.equals(o);
    }

    public int hashCode() {
        return this.parameters.hashCode();
    }
}

