/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.consumer.net;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.springframework.security.oauth.consumer.OAuthConsumerSupport;
import org.springframework.security.oauth.consumer.OAuthConsumerToken;
import org.springframework.security.oauth.consumer.ProtectedResourceDetails;
import sun.net.www.protocol.https.Handler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthOverHttpsURLStreamHandler
extends Handler {
    private final ProtectedResourceDetails resourceDetails;
    private final OAuthConsumerToken accessToken;
    private final OAuthConsumerSupport support;
    private final String httpMethod;
    private final Map<String, String> additionalParameters;

    public OAuthOverHttpsURLStreamHandler(ProtectedResourceDetails resourceDetails, OAuthConsumerToken accessToken, OAuthConsumerSupport support, String httpMethod, Map<String, String> additionalParameters) {
        this.resourceDetails = resourceDetails;
        this.accessToken = accessToken;
        this.support = support;
        this.httpMethod = httpMethod;
        this.additionalParameters = additionalParameters;
    }

    @Override
    protected URLConnection openConnection(URL url, Proxy proxy) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)super.openConnection(url, proxy);
        connection.setRequestMethod(this.httpMethod);
        if (this.resourceDetails.isAcceptsAuthorizationHeader()) {
            String authHeader = this.support.getAuthorizationHeader(this.resourceDetails, this.accessToken, url, this.httpMethod, this.additionalParameters);
            connection.setRequestProperty("Authorization", authHeader);
        }
        return connection;
    }
}

