/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.codec.Base64;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.OAuth2GrantManager;
import org.springframework.security.oauth2.provider.password.ClientPasswordAuthenticationToken;
import org.springframework.security.oauth2.provider.refresh.RefreshAuthenticationToken;
import org.springframework.security.oauth2.provider.verification.AuthorizationCodeAuthenticationToken;

public class DefaultOAuth2GrantManager
implements OAuth2GrantManager {
    private String credentialsCharset = "UTF-8";

    public Authentication setupAuthentication(String grantType, HttpServletRequest request) {
        try {
            GrantType type = GrantType.valueOf(grantType);
            String clientId = request.getParameter("client_id");
            String clientSecret = this.findClientSecret(clientId, request);
            Set<String> scope = OAuth2Utils.parseScope(request.getParameter("scope"));
            switch (type) {
                case authorization_code: {
                    String authCode = request.getParameter("code");
                    String redirectUri = request.getParameter("redirect_uri");
                    return new AuthorizationCodeAuthenticationToken(clientId, clientSecret, scope, authCode, redirectUri);
                }
                case password: {
                    String username = request.getParameter("username");
                    String password = request.getParameter("password");
                    return new ClientPasswordAuthenticationToken(clientId, clientSecret, scope, username, password);
                }
                case refresh_token: {
                    String refreshToken = request.getParameter("refresh_token");
                    return new RefreshAuthenticationToken(clientId, clientSecret, refreshToken);
                }
                case client_credentials: {
                    return null;
                }
            }
            return null;
        }
        catch (IllegalArgumentException e) {
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    protected String findClientSecret(String clientId, HttpServletRequest request) throws UnsupportedEncodingException {
        Enumeration headers;
        String clientSecret = request.getParameter("client_secret");
        if (clientSecret == null && (headers = request.getHeaders("Authorization")) != null) {
            while (headers.hasMoreElements()) {
                String header = (String)headers.nextElement();
                if (!header.startsWith("Basic ")) continue;
                byte[] base64Token = header.substring(6).getBytes("UTF-8");
                String token = new String(Base64.decode((byte[])base64Token), this.getCredentialsCharset());
                String username = "";
                String password = "";
                int delim = token.indexOf(":");
                if (delim != -1) {
                    username = token.substring(0, delim);
                    password = token.substring(delim + 1);
                }
                if (!username.equals(clientId)) continue;
                clientSecret = password;
                break;
            }
        }
        return clientSecret;
    }

    public String getCredentialsCharset() {
        return this.credentialsCharset;
    }

    public void setCredentialsCharset(String credentialsCharset) {
        if (credentialsCharset == null) {
            throw new NullPointerException("credentials charset must not be null.");
        }
        this.credentialsCharset = credentialsCharset;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GrantType {
        authorization_code,
        password,
        client_credentials,
        refresh_token;

    }
}

