/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.consumer.auth;

import java.io.UnsupportedEncodingException;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.security.core.codec.Base64;
import org.springframework.security.oauth2.consumer.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.consumer.auth.ClientAuthenticationHandler;
import org.springframework.security.oauth2.consumer.auth.ClientAuthenticationScheme;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClientAuthenticationHandler
implements ClientAuthenticationHandler {
    @Override
    public void authenticateTokenRequest(OAuth2ProtectedResourceDetails resource, MultiValueMap<String, String> form, ClientHttpRequest request) {
        if (resource.isSecretRequired()) {
            ClientAuthenticationScheme scheme = ClientAuthenticationScheme.http_basic;
            if (resource.getClientAuthenticationScheme() != null) {
                scheme = ClientAuthenticationScheme.valueOf(resource.getClientAuthenticationScheme());
            }
            try {
                switch (scheme) {
                    case http_basic: {
                        request.getHeaders().add("Authorization", String.format("Basic %s", new String(Base64.encode((byte[])String.format("%s:%s", resource.getClientId(), resource.getClientSecret()).getBytes("UTF-8")), "UTF-8")));
                        break;
                    }
                    case form: {
                        form.add((Object)"client_secret", (Object)String.valueOf(resource.getClientSecret()));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Default authentication handler doesn't know how to handle scheme: " + (Object)((Object)scheme));
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

