/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.oauth2.config.ResourceDetailsServiceFactoryBean;
import org.springframework.security.oauth2.consumer.OAuth2ClientContextFilter;
import org.springframework.security.oauth2.consumer.OAuth2ClientProcessingFilter;
import org.springframework.security.oauth2.consumer.OAuth2ProfileChain;
import org.springframework.security.oauth2.consumer.rememberme.HttpSessionOAuth2RememberMeServices;
import org.springframework.security.oauth2.consumer.token.InMemoryOAuth2ClientTokenServices;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.RequestKey;
import org.springframework.security.web.util.AntUrlPathMatcher;
import org.springframework.security.web.util.RegexUrlPathMatcher;
import org.springframework.security.web.util.UrlMatcher;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth2ClientBeanDefinitionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinition filterChainProxy = parserContext.getRegistry().getBeanDefinition("org.springframework.security.filterChainProxy");
        Map filterChainMap = (Map)filterChainProxy.getPropertyValues().getPropertyValue("filterChainMap").getValue();
        List<BeanMetadataElement> filterChain = this.findFilterChain(filterChainMap);
        if (filterChain == null) {
            throw new IllegalStateException("Unable to find the filter chain for the universal pattern matcher where the oauth filters are to be inserted.");
        }
        String tokenServicesRef = element.getAttribute("token-services-ref");
        String resourceDetailsServiceRef = element.getAttribute("resource-details-service-ref");
        String rememberMeServicesRef = element.getAttribute("remember-me-services-ref");
        String profileManagerRef = element.getAttribute("profile-manager-ref");
        String requireAuthenticated = element.getAttribute("requireAuthenticated");
        if (!StringUtils.hasText((String)tokenServicesRef)) {
            tokenServicesRef = "oauth2ClientTokenServices";
            BeanDefinitionBuilder tokenServices = BeanDefinitionBuilder.rootBeanDefinition(InMemoryOAuth2ClientTokenServices.class);
            parserContext.getRegistry().registerBeanDefinition(tokenServicesRef, (BeanDefinition)tokenServices.getBeanDefinition());
        }
        if (!StringUtils.hasText((String)rememberMeServicesRef)) {
            rememberMeServicesRef = "oauth2ClientRememberMeServices";
            BeanDefinitionBuilder rememberMeServices = BeanDefinitionBuilder.rootBeanDefinition(HttpSessionOAuth2RememberMeServices.class);
            parserContext.getRegistry().registerBeanDefinition(rememberMeServicesRef, (BeanDefinition)rememberMeServices.getBeanDefinition());
        }
        if (!StringUtils.hasText((String)resourceDetailsServiceRef)) {
            resourceDetailsServiceRef = "oauth2ResourceDetailsService";
            BeanDefinitionBuilder resourceDetailsService = BeanDefinitionBuilder.rootBeanDefinition(ResourceDetailsServiceFactoryBean.class);
            parserContext.getRegistry().registerBeanDefinition(resourceDetailsServiceRef, (BeanDefinition)resourceDetailsService.getBeanDefinition());
        }
        if (!StringUtils.hasText((String)profileManagerRef)) {
            profileManagerRef = "oauth2ClientProfileManager";
            BeanDefinitionBuilder flowManager = BeanDefinitionBuilder.rootBeanDefinition(OAuth2ProfileChain.class);
            if ("false".equalsIgnoreCase(requireAuthenticated)) {
                flowManager.addPropertyValue("requireAuthenticated", (Object)"false");
            }
            flowManager.addPropertyReference("tokenServices", tokenServicesRef);
            parserContext.getRegistry().registerBeanDefinition(profileManagerRef, (BeanDefinition)flowManager.getBeanDefinition());
        }
        BeanDefinitionBuilder clientContextFilterBean = BeanDefinitionBuilder.rootBeanDefinition(OAuth2ClientContextFilter.class);
        clientContextFilterBean.addPropertyReference("profileManager", profileManagerRef);
        clientContextFilterBean.addPropertyReference("rememberMeServices", rememberMeServicesRef);
        int filterIndex = this.insertIndex(filterChain);
        parserContext.getRegistry().registerBeanDefinition("oauth2ClientContextFilter", (BeanDefinition)clientContextFilterBean.getBeanDefinition());
        filterChain.add(filterIndex++, (BeanMetadataElement)new RuntimeBeanReference("oauth2ClientContextFilter"));
        List filterPatterns = DomUtils.getChildElementsByTagName((Element)element, (String)"url");
        if (!filterPatterns.isEmpty()) {
            boolean useLowerCasePaths;
            String lowercaseComparisons;
            BeanDefinitionBuilder consumerFilterBean = BeanDefinitionBuilder.rootBeanDefinition(OAuth2ClientProcessingFilter.class);
            String patternType = element.getAttribute("path-type");
            if (!StringUtils.hasText((String)patternType)) {
                patternType = "ant";
            }
            boolean useRegex = patternType.equals("regex");
            AntUrlPathMatcher matcher = new AntUrlPathMatcher();
            if (useRegex) {
                matcher = new RegexUrlPathMatcher();
            }
            if (!StringUtils.hasText((String)(lowercaseComparisons = element.getAttribute("lowercase-comparisons")))) {
                lowercaseComparisons = null;
            }
            if ("true".equals(lowercaseComparisons)) {
                if (useRegex) {
                    ((RegexUrlPathMatcher)matcher).setRequiresLowerCaseUrl(true);
                }
            } else if ("false".equals(lowercaseComparisons) && !useRegex) {
                matcher.setRequiresLowerCaseUrl(false);
            }
            LinkedHashMap<RequestKey, List> invocationDefinitionMap = new LinkedHashMap<RequestKey, List>();
            Iterator filterPatternIt = filterPatterns.iterator();
            boolean bl = useLowerCasePaths = matcher instanceof AntUrlPathMatcher && matcher.requiresLowerCaseUrl();
            while (filterPatternIt.hasNext()) {
                String access;
                String method;
                Element filterPattern = (Element)filterPatternIt.next();
                String path = filterPattern.getAttribute("pattern");
                if (!StringUtils.hasText((String)path)) {
                    parserContext.getReaderContext().error("pattern attribute cannot be empty or null", (Object)filterPattern);
                }
                if (useLowerCasePaths) {
                    path = path.toLowerCase();
                }
                if (!StringUtils.hasText((String)(method = filterPattern.getAttribute("httpMethod")))) {
                    method = null;
                }
                if (!StringUtils.hasText((String)(access = filterPattern.getAttribute("resources")))) continue;
                invocationDefinitionMap.put(new RequestKey(path, method), SecurityConfig.createList((String[])StringUtils.commaDelimitedListToStringArray((String)access)));
            }
            DefaultFilterInvocationSecurityMetadataSource source = new DefaultFilterInvocationSecurityMetadataSource((UrlMatcher)matcher, invocationDefinitionMap);
            source.setStripQueryStringFromUrls(true);
            consumerFilterBean.addPropertyValue("objectDefinitionSource", (Object)source);
            consumerFilterBean.addPropertyReference("resourceDetailsService", resourceDetailsServiceRef);
            parserContext.getRegistry().registerBeanDefinition("oauth2ClientSecurityFilter", (BeanDefinition)consumerFilterBean.getBeanDefinition());
            filterChain.add(filterIndex++, (BeanMetadataElement)new RuntimeBeanReference("oauth2ClientSecurityFilter"));
        }
        return null;
    }

    protected List<BeanMetadataElement> findFilterChain(Map filterChainMap) {
        Iterator valuesIt = filterChainMap.values().iterator();
        while (valuesIt.hasNext()) {
            List filterChain = (List)valuesIt.next();
            if (valuesIt.hasNext()) continue;
            return filterChain;
        }
        return null;
    }

    private int insertIndex(List<BeanMetadataElement> filterChain) {
        for (int i = 0; i < filterChain.size(); ++i) {
            String beanName;
            BeanMetadataElement filter = filterChain.get(i);
            if (!(filter instanceof BeanDefinition) || !(beanName = ((BeanDefinition)filter).getBeanClassName()).equals(ExceptionTranslationFilter.class.getName())) continue;
            return i + 1;
        }
        return filterChain.size();
    }
}

