/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth2Authentication<C extends Authentication, U extends Authentication>
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = -4809832298438307309L;
    private final C clientAuthentication;
    private final U userAuthentication;

    public OAuth2Authentication(C clientAuthentication, U userAuthentication) {
        super(userAuthentication == null ? clientAuthentication.getAuthorities() : userAuthentication.getAuthorities());
        this.clientAuthentication = clientAuthentication;
        this.userAuthentication = userAuthentication;
    }

    public Object getCredentials() {
        return this.userAuthentication == null ? this.clientAuthentication.getCredentials() : this.userAuthentication.getCredentials();
    }

    public Object getPrincipal() {
        return this.userAuthentication == null ? this.clientAuthentication.getPrincipal() : this.userAuthentication.getPrincipal();
    }

    public C getClientAuthentication() {
        return this.clientAuthentication;
    }

    public U getUserAuthentication() {
        return this.userAuthentication;
    }

    public boolean isAuthenticated() {
        return this.clientAuthentication.isAuthenticated() && (this.userAuthentication == null || this.userAuthentication.isAuthenticated());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuth2Authentication)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuth2Authentication that = (OAuth2Authentication)((Object)o);
        if (!this.clientAuthentication.equals(that.clientAuthentication)) {
            return false;
        }
        return !(this.userAuthentication != null ? !this.userAuthentication.equals(that.userAuthentication) : that.userAuthentication != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.clientAuthentication.hashCode();
        result = 31 * result + (this.userAuthentication != null ? this.userAuthentication.hashCode() : 0);
        return result;
    }
}

