/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config;

import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.oauth2.provider.BaseClientDetails;
import org.springframework.security.oauth2.provider.InMemoryClientDetailsService;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ClientServiceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected Class getBeanClass(Element element) {
        return InMemoryClientDetailsService.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List clientElements = DomUtils.getChildElementsByTagName((Element)element, (String)"client");
        ManagedMap clients = new ManagedMap();
        for (Object item : clientElements) {
            BeanDefinitionBuilder client = BeanDefinitionBuilder.rootBeanDefinition(BaseClientDetails.class);
            Element clientElement = (Element)item;
            String clientId = clientElement.getAttribute("clientId");
            if (StringUtils.hasText((String)clientId)) {
                client.addPropertyValue("clientId", (Object)clientId);
            } else {
                parserContext.getReaderContext().error("A client id must be supplied with the definition of a client.", (Object)clientElement);
            }
            String secret = clientElement.getAttribute("secret");
            if (StringUtils.hasText((String)secret)) {
                client.addPropertyValue("clientSecret", (Object)secret);
            }
            client.addConstructorArgValue((Object)clientElement.getAttribute("scope"));
            client.addConstructorArgValue((Object)clientElement.getAttribute("authorizedGrantTypes"));
            client.addConstructorArgValue((Object)clientElement.getAttribute("authorities"));
            clients.put((Object)clientId, (Object)client.getBeanDefinition());
        }
        builder.addPropertyValue("clientDetailsStore", (Object)clients);
    }
}

