/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test.internal.util;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class PropertiesUtil {
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";
    private static final Properties EMPTY_PROPERTIES = new Properties();

    public static Properties loadAndExpand(Resource resource) {
        Properties props = new Properties();
        if (resource == null) {
            return props;
        }
        try {
            props.load(resource.getInputStream());
        }
        catch (IOException ex) {
            return null;
        }
        return PropertiesUtil.expandProperties(props);
    }

    public static Properties filterKeysStartingWith(Properties properties, String prefix) {
        if (!StringUtils.hasText((String)prefix)) {
            return EMPTY_PROPERTIES;
        }
        Assert.notNull((Object)properties);
        Properties excluded = new Properties();
        Enumeration<Object> enm = properties.keys();
        while (enm.hasMoreElements()) {
            String key = (String)enm.nextElement();
            if (!key.startsWith(prefix)) continue;
            excluded.put(key, properties.remove(key));
        }
        return excluded;
    }

    public static Properties filterValuesStartingWith(Properties properties, String prefix) {
        if (!StringUtils.hasText((String)prefix)) {
            return EMPTY_PROPERTIES;
        }
        Assert.notNull((Object)properties);
        Properties excluded = new Properties();
        Enumeration<Object> enm = properties.keys();
        while (enm.hasMoreElements()) {
            String key = (String)enm.nextElement();
            String value = properties.getProperty(key);
            if (!value.startsWith(prefix)) continue;
            excluded.put(key, value);
            properties.remove(key);
        }
        return excluded;
    }

    public static Properties expandProperties(Properties props) {
        Assert.notNull((Object)props);
        Set<Map.Entry<Object, Object>> entrySet = props.entrySet();
        Properties newProps = new Properties();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String resultKey = PropertiesUtil.expandProperty(key, props);
            String resultValue = PropertiesUtil.expandProperty(value, props);
            newProps.put(resultKey, resultValue);
        }
        return newProps;
    }

    private static String expandProperty(String prop, Properties properties) throws IllegalArgumentException {
        boolean hasPlaceholder = false;
        String copy = prop;
        StringBuilder result = new StringBuilder();
        int index = 0;
        do {
            if ((index = copy.indexOf(DELIM_START)) >= 0) {
                hasPlaceholder = true;
                result.append(copy.substring(0, index));
                copy = copy.substring(index + DELIM_START.length());
                int stopIndex = copy.indexOf(DELIM_STOP);
                String token = null;
                if (stopIndex >= 0) {
                    token = copy.substring(0, stopIndex);
                    copy = copy.substring(stopIndex + 1);
                    result.append(properties.getProperty(token));
                    continue;
                }
                throw new IllegalArgumentException("cannot interpret property " + prop + " due of token [" + copy + "]");
            }
            hasPlaceholder = false;
            result.append(copy);
        } while (hasPlaceholder);
        return result.toString();
    }
}

