/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test.internal.util;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class DependencyVisitor
implements AnnotationVisitor,
SignatureVisitor,
ClassVisitor,
FieldVisitor,
MethodVisitor {
    private Set packages = new LinkedHashSet();
    private Map groups = new LinkedHashMap();
    private Map current;
    private String tempLdc;
    private String ownerName;
    private Set innerClasses = new LinkedHashSet(4);
    private static final String CLASS_NAME = Class.class.getName();

    public Map getGlobals() {
        return this.groups;
    }

    public Set getPackages() {
        return this.packages;
    }

    public Set getInnerClasses() {
        return this.innerClasses;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.tempLdc = null;
        this.ownerName = name;
        String p = this.getGroupKey(name);
        this.current = (Map)this.groups.get(p);
        if (this.current == null) {
            this.current = new LinkedHashMap();
            this.groups.put(p, this.current);
        }
        if (signature == null) {
            this.addName(superName);
            this.addNames(interfaces);
        } else {
            this.addSignature(signature);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.tempLdc = null;
        this.addDesc(desc);
        return this;
    }

    public void visitAttribute(Attribute attr) {
        this.tempLdc = null;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.tempLdc = null;
        if (signature == null) {
            this.addDesc(desc);
        } else {
            this.addTypeSignature(signature);
        }
        if (value instanceof Type) {
            this.addType((Type)value);
        }
        return this;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.tempLdc = null;
        if (signature == null) {
            this.addMethodDesc(desc);
        } else {
            this.addSignature(signature);
        }
        this.addNames(exceptions);
        return this;
    }

    public void visitSource(String source, String debug) {
        this.tempLdc = null;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.tempLdc = null;
        this.addName(name);
        this.addName(outerName);
        if (!this.ownerName.equals(name)) {
            this.innerClasses.add(name);
        }
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.tempLdc = null;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        this.tempLdc = null;
        this.addDesc(desc);
        return this;
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.tempLdc = null;
        if (desc.charAt(0) == '[') {
            this.addDesc(desc);
        } else {
            this.addName(desc);
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.tempLdc = null;
        this.addName(owner);
        this.addDesc(desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        String returnType = Type.getReturnType((String)desc).getClassName();
        if (opcode == 184 && CLASS_NAME.equals(returnType) && this.tempLdc != null) {
            this.addName(this.tempLdc.replace('.', '/'));
        }
        this.tempLdc = null;
        this.addName(owner);
        this.addMethodDesc(desc);
    }

    public void visitLdcInsn(Object cst) {
        this.tempLdc = null;
        if (cst instanceof Type) {
            this.addType((Type)cst);
        } else if (cst instanceof String) {
            this.tempLdc = (String)cst;
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.tempLdc = null;
        this.addDesc(desc);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.tempLdc = null;
        this.addTypeSignature(signature);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        this.tempLdc = null;
        return this;
    }

    public void visitCode() {
        this.tempLdc = null;
    }

    public void visitInsn(int opcode) {
        this.tempLdc = null;
    }

    public void visitIntInsn(int opcode, int operand) {
        this.tempLdc = null;
    }

    public void visitVarInsn(int opcode, int var) {
        this.tempLdc = null;
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.tempLdc = null;
    }

    public void visitLabel(Label label) {
        this.tempLdc = null;
    }

    public void visitIincInsn(int var, int increment) {
        this.tempLdc = null;
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.tempLdc = null;
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.tempLdc = null;
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.tempLdc = null;
        this.addName(type);
    }

    public void visitLineNumber(int line, Label start) {
        this.tempLdc = null;
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.tempLdc = null;
    }

    public void visit(String name, Object value) {
        this.tempLdc = null;
        if (value instanceof Type) {
            this.addType((Type)value);
        }
    }

    public void visitEnum(String name, String desc, String value) {
        this.tempLdc = null;
        this.addDesc(desc);
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        this.tempLdc = null;
        this.addDesc(desc);
        return this;
    }

    public AnnotationVisitor visitArray(String name) {
        this.tempLdc = null;
        return this;
    }

    public void visitFormalTypeParameter(String name) {
        this.tempLdc = null;
    }

    public SignatureVisitor visitClassBound() {
        this.tempLdc = null;
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.tempLdc = null;
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        this.tempLdc = null;
        return this;
    }

    public SignatureVisitor visitInterface() {
        this.tempLdc = null;
        return this;
    }

    public SignatureVisitor visitParameterType() {
        this.tempLdc = null;
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.tempLdc = null;
        return this;
    }

    public SignatureVisitor visitExceptionType() {
        this.tempLdc = null;
        return this;
    }

    public void visitBaseType(char descriptor) {
        this.tempLdc = null;
    }

    public void visitTypeVariable(String name) {
        this.tempLdc = null;
    }

    public SignatureVisitor visitArrayType() {
        this.tempLdc = null;
        return this;
    }

    public void visitClassType(String name) {
        this.tempLdc = null;
        this.addName(name);
    }

    public void visitInnerClassType(String name) {
        this.tempLdc = null;
        this.addName(name);
    }

    public void visitTypeArgument() {
        this.tempLdc = null;
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        this.tempLdc = null;
        return this;
    }

    public void visitEnd() {
        this.tempLdc = null;
    }

    private String getGroupKey(String name) {
        int n = name.lastIndexOf(47);
        if (n > -1) {
            name = name.substring(0, n);
        }
        this.packages.add(name);
        return name;
    }

    private void addName(String name) {
        if (name == null) {
            return;
        }
        String p = this.getGroupKey(name);
        if (this.current.containsKey(p)) {
            this.current.put(p, new Integer((Integer)this.current.get(p) + 1));
        } else {
            this.current.put(p, new Integer(1));
        }
    }

    private void addNames(String[] names) {
        for (int i = 0; names != null && i < names.length; ++i) {
            this.addName(names[i]);
        }
    }

    private void addDesc(String desc) {
        this.addType(Type.getType((String)desc));
    }

    private void addMethodDesc(String desc) {
        this.addType(Type.getReturnType((String)desc));
        Type[] types = Type.getArgumentTypes((String)desc);
        for (int i = 0; i < types.length; ++i) {
            this.addType(types[i]);
        }
    }

    private void addType(Type t) {
        switch (t.getSort()) {
            case 9: {
                this.addType(t.getElementType());
                break;
            }
            case 10: {
                this.addName(t.getClassName().replace('.', '/'));
            }
        }
    }

    private void addSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).accept((SignatureVisitor)this);
        }
    }

    private void addTypeSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).acceptType((SignatureVisitor)this);
        }
    }
}

