/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test.internal.support;

import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.osgi.test.internal.OsgiJUnitTest;
import org.springframework.osgi.test.internal.TestRunnerService;
import org.springframework.osgi.test.internal.holder.HolderLoader;
import org.springframework.osgi.test.internal.holder.OsgiTestInfoHolder;
import org.springframework.osgi.test.internal.util.TestUtils;

public class OsgiJUnitService
implements TestRunnerService {
    private static final Log log = LogFactory.getLog(OsgiJUnitService.class);

    public void runTest(OsgiJUnitTest test) {
        try {
            this.executeTest(test);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException("cannot execute test:" + ex, ex);
        }
    }

    protected void executeTest(OsgiJUnitTest test) throws Exception {
        OsgiTestInfoHolder holder = HolderLoader.INSTANCE.getHolder();
        String testName = holder.getTestMethodName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading test [" + testName + "] for execution inside OSGi"));
        }
        TestResult result = this.runTest(test, testName);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sending test results from OSGi");
        }
        TestUtils.unpackProblems(result, holder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TestResult runTest(final OsgiJUnitTest osgiTestExtensions, String testName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Running test [" + testName + "] on testCase " + osgiTestExtensions));
        }
        TestResult result = new TestResult();
        TestCase rawTest = osgiTestExtensions.getTestCase();
        rawTest.setName(testName);
        try {
            osgiTestExtensions.osgiSetUp();
            try {
                result.runProtected((Test)rawTest, new Protectable(){

                    public void protect() throws Throwable {
                        osgiTestExtensions.osgiRunTest();
                    }
                });
            }
            finally {
                osgiTestExtensions.osgiTearDown();
            }
        }
        catch (Exception ex) {
            log.error((Object)"test exception threw exception ", (Throwable)ex);
            result.addError((Test)rawTest, (Throwable)ex);
        }
        return result;
    }
}

