/*
 * Copyright 2006-2009 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.osgi.test.platform;

import org.osgi.framework.BundleContext;

/**
 * Internal interface used for starting different versions of the same platform (such as Felix 1.0.x vs 1.2.x vs 2.x).
 * 
 * @author Costin Leau
 */
interface Platform {

	BundleContext start() throws Exception;

	void stop() throws Exception;
}
