/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.mock;

import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.mock.ArrayEnumerator;
import org.springframework.osgi.mock.MockBundle;

public class EntryLookupControllingMockBundle
extends MockBundle {
    protected Enumeration nextFindResult = null;
    protected URL nextEntryResult = null;

    public EntryLookupControllingMockBundle(Dictionary headers) {
        super(headers);
    }

    public void setResultsToReturnOnNextCallToFindEntries(String[] findResult) {
        if (findResult == null) {
            findResult = new String[]{};
        }
        this.nextFindResult = this.createEnumerationOver(findResult);
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        if (this.nextFindResult == null) {
            return super.findEntries(path, filePattern, recurse);
        }
        Enumeration ret = this.nextFindResult;
        this.nextFindResult = null;
        return ret;
    }

    public void setEntryReturnOnNextCallToGetEntry(URL entry) {
        this.nextEntryResult = entry;
    }

    public URL getEntry(String name) {
        if (this.nextEntryResult != null) {
            URL result = this.nextEntryResult;
            this.nextEntryResult = null;
            return result;
        }
        return super.getEntry(name);
    }

    public URL getResource(String name) {
        return this.getEntry(name);
    }

    public BundleContext getContext() {
        return super.getContext();
    }

    protected Enumeration createEnumerationOver(String[] entries) {
        return new ArrayEnumerator<String>(entries);
    }
}

