/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device.wurfl.wng;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.wurfl.core.Device;
import net.sourceforge.wurfl.wng.WNGDevice;
import net.sourceforge.wurfl.wng.component.Component;
import net.sourceforge.wurfl.wng.component.ComponentException;
import net.sourceforge.wurfl.wng.component.ComponentVisitor;
import net.sourceforge.wurfl.wng.component.Document;
import net.sourceforge.wurfl.wng.component.StyleContainer;
import net.sourceforge.wurfl.wng.component.ValidatorVisitor;
import net.sourceforge.wurfl.wng.renderer.DefaultDocumentRenderer;
import net.sourceforge.wurfl.wng.renderer.DefaultRendererGroupResolver;
import net.sourceforge.wurfl.wng.renderer.DocumentRenderer;
import net.sourceforge.wurfl.wng.renderer.RenderedDocument;
import net.sourceforge.wurfl.wng.renderer.RendererGroupResolver;
import net.sourceforge.wurfl.wng.style.StyleOptimizerVisitor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.springframework.mobile.device.DeviceUtils;
import org.springframework.mobile.device.wurfl.wng.BufferedHttpServletResponse;
import org.springframework.web.servlet.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WngView
implements View {
    private final View target;
    private final DocumentRenderer documentRenderer;

    public WngView(View target) {
        this(target, (DocumentRenderer)new DefaultDocumentRenderer((RendererGroupResolver)new DefaultRendererGroupResolver()));
    }

    public WngView(View target, DocumentRenderer documentRenderer) {
        this.target = target;
        this.documentRenderer = documentRenderer;
    }

    public String getContentType() {
        return this.target.getContentType();
    }

    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BufferedHttpServletResponse buffered = new BufferedHttpServletResponse(response);
        this.target.render(model, request, (HttpServletResponse)buffered);
        if (this.isWngDocumentCreated((ServletRequest)request)) {
            WNGDevice device = new WNGDevice((Device)DeviceUtils.getRequiredCurrentDevice(request));
            Document document = this.resolveDocument((ServletRequest)request);
            StyleContainer styleContainer = (StyleContainer)CollectionUtils.find((Collection)document.getHead().getChildren(), (Predicate)new InstanceofPredicate(StyleContainer.class));
            if (styleContainer == null) {
                styleContainer = new StyleContainer();
                document.addToHead((Component)styleContainer);
            }
            StyleOptimizerVisitor visitor = new StyleOptimizerVisitor(device, styleContainer);
            document.accept((ComponentVisitor)visitor);
            RenderedDocument renderedDocument = this.documentRenderer.renderDocument(document, device);
            this.writeDocument(renderedDocument, response);
        } else {
            buffered.writeTo((OutputStream)response.getOutputStream());
        }
    }

    private boolean isWngDocumentCreated(ServletRequest request) {
        return request.getAttribute("net.sourceforge.wurfl.wng.DOCUMENT") != null;
    }

    private Document resolveDocument(ServletRequest request) throws ComponentException {
        Document document = (Document)request.getAttribute("net.sourceforge.wurfl.wng.DOCUMENT");
        ValidatorVisitor validatorVisitor = new ValidatorVisitor();
        document.accept((ComponentVisitor)validatorVisitor);
        return document;
    }

    private void writeDocument(RenderedDocument renderedDocument, HttpServletResponse response) throws IOException {
        response.setContentType(renderedDocument.getContentType());
        response.getWriter().print(renderedDocument.getMarkup());
        response.getWriter().flush();
    }
}

