/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device.switcher;

import javax.servlet.http.HttpServletRequest;
import org.springframework.mobile.device.switcher.SiteUrlFactory;

public class StandardSiteUrlFactory
implements SiteUrlFactory {
    private final String serverName;

    public StandardSiteUrlFactory(String serverName) {
        this.serverName = serverName;
    }

    public boolean isRequestForSite(HttpServletRequest request) {
        return this.serverName.equals(request.getServerName());
    }

    public String createSiteUrl(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        builder.append(request.getScheme()).append("://").append(this.serverName);
        String optionalPort = this.optionalPort(request);
        if (optionalPort != null) {
            builder.append(optionalPort);
        }
        builder.append(request.getRequestURI());
        return builder.toString();
    }

    private String optionalPort(HttpServletRequest request) {
        if ("http".equals(request.getScheme()) && request.getServerPort() != 80 || "https".equals(request.getScheme()) && request.getServerPort() != 443) {
            return ":" + request.getServerPort();
        }
        return null;
    }
}

